require([
    'jquery',
    'underscore',
    'wrm/require',
    'quick-edit/util/loading-indicator',
    'jira/ajs/keyboardshortcut/keyboard-shortcut-toggle'
], function (
    jQuery,
    _,
    wrmRequire,
    LoadingIndicator,
    KeyboardShortcutToggle
) {
    var showLoadingIndicator = function () {
        KeyboardShortcutToggle.disable();
        LoadingIndicator.showLoadingIndicator();
    };
    var hideLoadingIndicator = function () {
        LoadingIndicator.hideLoadingIndicator(true);
        KeyboardShortcutToggle.enable();
    };

    var subtaskTrigger;

    var createIssueDialogLoading = false;
    jQuery(document).on("simpleClick", ".create-issue, .create-issue-type", function(e) {
        e.preventDefault();
        if( !createIssueDialogLoading ) {
            createIssueDialogLoading = true;
            showLoadingIndicator();
            var resourceKey = 'wr!com.atlassian.jira.jira-quick-edit-plugin:quick-create-issue';
            var wrmRequireDeferred = wrmRequire([resourceKey]);
            wrmRequireDeferred.then(onDone.bind(undefined, e), function onFail() {
                hideLoadingIndicator();
                createIssueDialogLoading = false;
            });
        }
    });
    var onDone = function (e) {
        var InitCreateDialogs = require('quick-edit/init/create');
        InitCreateDialogs.initIssueDialog(e);

        KeyboardShortcutToggle.enable();
        createIssueDialogLoading = false;
    };

jQuery(function () {
    subtaskTrigger = document.getElementById("stqc_show");

    // remove old subtask form
    if (subtaskTrigger) {
        subtaskTrigger.onclick = null;
    }
});

    var createSubtaskDialogLoading = false;
    jQuery(document).on("simpleClick", ".issueaction-create-subtask", function(e) {
        e.preventDefault();
        if (!createSubtaskDialogLoading) {
            createSubtaskDialogLoading = true;
            showLoadingIndicator();
            var resourceKey = 'wr!com.atlassian.jira.jira-quick-edit-plugin:quick-create-issue';
            var wrmRequireDeferred = wrmRequire([resourceKey]);
            wrmRequireDeferred.then(onDoneSubtask, function onFail() {
                hideLoadingIndicator();
                createSubtaskDialogLoading = false;
            });
        }
    });
    var onDoneSubtask = function (e) {
        var InitCreateDialogs = require('quick-edit/init/create');
        InitCreateDialogs.initSubtaskDialog(e);

        KeyboardShortcutToggle.enable();
        createSubtaskDialogLoading = false;
    }
});
