/**
 * @module quick-edit/form/model/edit-issue
 */
define('quick-edit/form/model/edit-issue', [
    'quick-edit/form/model',
    'underscore',
    'jquery'
], function(
    FormModel,
    _,
    jQuery
){
    'use strict';

    /**
     * A special Model for quick edit. Has special handling for comment field. Comment field can be toggled on and off on
     * configurable form. On unconfigurable form it is always present.
     *
     * @class EditIssueFormModel
     * @extends FormModel
     */
    return FormModel.extend({
        /**
         * Gets tabs removing comment field if it is present.
         *
         * @return jQuery.promise
         */
        getUnconfigurableTabs: function () {
            var instance = this,
                deferred = jQuery.Deferred();

            instance.getTabs().done(function (tabs) {
                var newTabRef = tabs.slice(0); // Create a new array reference so we do not modify existing

                newTabRef[0].fields = newTabRef[0].fields.slice(0);

                jQuery.each(newTabRef[0].fields, function (i, field) {
                    if (field.id === "comment") {
                        newTabRef[0].fields.splice(i, 1);
                        return false; // bail
                    }
                });

                deferred.resolve(newTabRef);
            });

            return deferred.promise();
        },

        /**
         * Gets comment field
         *
         * @return jQuery.promise
         */
        getCommentField: function () {
            var deferred = jQuery.Deferred();

            this.getFields().done(function (fields) {
                jQuery.each(fields, function (i, field) {
                    if (field.id === "comment") {
                        deferred.resolve(field);
                    }
                });

                deferred.reject();
            });

            return deferred.promise();
        }
    });
});

/**
 * @deprecated JIRA.Forms.EditIssueModel
 */
AJS.namespace('JIRA.Forms.EditIssueModel', null, require('quick-edit/form/model/edit-issue'));
