/**
 * @module quick-edit/form/field-picker/button/unconfigurable
 */
define('quick-edit/form/field-picker/button/unconfigurable', [
    'quick-edit/util/control',
    'quick-edit/templates/form',
    'jquery'
], function(
    Control,
    FormTemplates,
    jQuery
){
    'use strict';

    /**
     * @class UnconfigurableButton
     * @extends Control
     */
    return Control.extend({
        init: function (descriptor) {
            this.descriptor = descriptor;
        },

        render: function () {
            this.$element = jQuery(FormTemplates.unconfigurablePickerButton({
                required: this.descriptor.required,
                label: this.descriptor.label,
                fieldId: this.descriptor.id,
                isActive: true
            }));

            return this.$element;
        }
    });
});

/**
 * @deprecated JIRA.Forms.FieldPicker.UnconfigurableButton
 */
AJS.namespace('JIRA.Forms.FieldPicker.UnconfigurableButton', null, require('quick-edit/form/field-picker/button/unconfigurable'));