/**
 * @module quick-edit/form/field-picker/button/configurable
 */
define('quick-edit/form/field-picker/button/configurable', [
    'quick-edit/util/control',
    'quick-edit/templates/form'
], function(
    Control,
    FormTemplates
){
    'use strict';

    /**
     * A view class that renders a button that when clicked toggles the visibility of corresponding
     * @see ConfigurableField
     * @class ConfigurableButton
     * @extends Control
     */
    return Control.extend({
        /**
         * @constructor
         * @param options
         * ... {field} {@link ConfigurableField}
         */
        init: function (options) {
            var instance = this;

            this.field = options.field;

            this.field.bind("disabled", function () {
                instance.$element.removeClass("qf-active");
            }).bind("activated", function () {
                instance.$element.addClass("qf-active");
            });
        },

        /**
         * Toggles visibility of field
         */
        toggle: function () {
            if (this.field.isActive()) {
                this.field.disable();
            } else {
                this.field.activate();
            }
        },

        /**
         * Gets field id
         * @return {String}
         */
        getId: function () {
            return this.field.getId();
        },

        /**
         * Renders button
         * @return {jQuery}
         */
        render: function () {
            this.$element = jQuery(FormTemplates.configurablePickerButton({
                required: this.field.descriptor.required,
                label: this.field.getLabel(),
                fieldId: this.field.getId(),
                isActive: this.field.isActive()
            }));
            this._assignEvents("button", this.$element);
            return this.$element;
        },

        _events: {
            button: {
                click: function (e) {
                    this.toggle();
                    e.preventDefault();
                }
            }
        }
    });

});

/**
 * @deprecated JIRA.Forms.FieldPicker.ConfigurableButton
 */
AJS.namespace('JIRA.Forms.FieldPicker.ConfigurableButton', null, require('quick-edit/form/field-picker/button/configurable'));