/**
 * @module quick-edit/form/factory/edit-issue
 */
define('quick-edit/form/factory/edit-issue', [
    'quick-edit/form/container',
    'quick-edit/form/configurable/edit-issue',
    'quick-edit/form/error/edit-issue',
    'quick-edit/util/dialog',
    'quick-edit/form/model/factory/edit-issue',
    'quick-edit/form/unconfigurable-edit-issue',
    'jira/issue',
    'jira/issuenavigator/issue-navigator',
    'jquery'
], function(
    Container,
    ConfigurableEditIssueForm,
    EditIssueError,
    DialogUtil,
    editIssueFormModelFactory,
    UnconfigurableEditIssueForm,
    Issue,
    IssueNavigator,
    jQuery
){
    'use strict';

    function getSelectedIssueId (options) {
        var triggerIssueId = DialogUtil.getAttrFromActiveTrigger("data-issueId");

        if (jQuery.isFunction(options.issueId)) {
            return options.issueId(options);
        } else if (options.issueId) {
            return options.issueId;
        } else if (triggerIssueId) {
            return triggerIssueId;
        } else {
            return Issue.getIssueId() || IssueNavigator.getSelectedIssueId();
        }
    }

    // JRADEV-8599 Only Issue Navigator or sub-tasks should have Issue key shown in dialog title
    function getContainerTitle () {
        var editActionText = AJS.I18n.getText("admin.issue.operations.edit");

        if (DialogUtil.shouldShowIssueKeyInTitle()) {
            return DialogUtil.getIssueActionTitle(editActionText);
        } else {
            return editActionText;
        }
    }

    /**
     * Factory to create Edit Issue Form
     *
     * @param {String, Number} issueId
     * @return FormContainer
     */
    return function (options) {
        options = options || {};

        return new Container(function () {
            var issueId = getSelectedIssueId(options),
                title = getContainerTitle(),
                model = editIssueFormModelFactory(issueId),
                configurableForm = new ConfigurableEditIssueForm({
                    title: title,
                    model: model,
                    issueId: issueId,
                    globalEventNamespaces: ["QuickEdit"]
                }),
                unconfigurableForm = new UnconfigurableEditIssueForm({
                    title: title,
                    model: model,
                    issueId: issueId,
                    globalEventNamespaces: ["QuickEdit"]
                });
            return {
                globalEventNamespaces: ["QuickEdit"],
                model: model,
                errorHandler: new EditIssueError(),
                configurableForm: configurableForm,
                unconfigurableForm: unconfigurableForm
            };
        });
    };
});

/**
 * @deprecated JIRA.Forms.createEditIssueForm
 */
AJS.namespace('JIRA.Forms.createEditIssueForm', null, require('quick-edit/form/factory/edit-issue'));