/**
 * @module quick-edit/form/error
 */
define('quick-edit/form/error', [
    'quick-edit/util/control',
    'quick-edit/templates/form',
    'jira/ajs/ajax/smart-ajax'
], function(
    Control,
    FormTemplates,
    SmartAjax
){
    'use strict';

    /**
     * An abstract generic error message renderer
     *
     * @class FormError
     * @extends Control
     */
    return Control.extend({
        /**
         * Gets the best reason for error it can from a smartAjaxResult
         *
         * @param smartAjaxResult
         * @return String
         */
        getErrorMessageFromSmartAjax: function (smartAjaxResult) {
            var message, data;

            if (smartAjaxResult.hasData && smartAjaxResult.status !== 401) {
                try {
                    data = JSON.parse(smartAjaxResult.data);
                    if (data.errorMessages && data.errorMessages.length > 0) {
                        message = FormTemplates.errorMessage({
                            message: data.errorMessages[0]
                        });
                    } else {
                        message = SmartAjax.buildDialogErrorContent(smartAjaxResult, true).html();
                    }
                } catch (e) {
                    message = SmartAjax.buildDialogErrorContent(smartAjaxResult, true).html();
                }
            } else {
                message = SmartAjax.buildDialogErrorContent(smartAjaxResult, true).html();
            }

            return message;
        },

        /**
         * Renders error message
         *
         * @param smartAjaxResult
         */
        render: function (smartAjaxResult) {
            var errorMessage = this.getErrorMessageFromSmartAjax(smartAjaxResult);
            return this._render(errorMessage);
        }
    });

});

/**
 * @deprecated JIRA.Forms.Error
 */
AJS.namespace('JIRA.Forms.Error', null, require('quick-edit/form/error'));