/**
 * @module quick-edit/form/error/edit-issue
 */
define('quick-edit/form/error/edit-issue', [
    'quick-edit/form/error',
    'quick-edit/templates/issue',
    'jquery'
], function(
    Error,
    IssueTemplates,
    jQuery
){
    'use strict';

    /**
     * Renders an error message with edit issue furniture
     *
     * @class EditIssueFormError
     * @extends FormError
     */
    return Error.extend({
        _render: function (error) {
            return jQuery(IssueTemplates.editIssueError({
                errorHtml: error
            }));
        }
    });
});

/**
 * @deprecated JIRA.Forms.EditIssueError
 */
AJS.namespace('JIRA.Forms.EditIssueError', null, require('quick-edit/form/error/edit-issue'));

