/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.rest.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class UserPreferences {
    @XmlElement(name="showWelcomeScreen")
    private boolean showWelcomeScreen;
    @XmlElement(name="useQuickForm")
    private boolean useQuickForm;
    @XmlElement(name="fields")
    private List<String> fields = new ArrayList<String>();

    private UserPreferences() {
    }

    private UserPreferences(boolean showWelcomeScreen, boolean useQuickForm, List<String> fields) {
        this.showWelcomeScreen = showWelcomeScreen;
        this.useQuickForm = useQuickForm;
        this.fields = fields;
    }

    public boolean isShowWelcomeScreen() {
        return this.showWelcomeScreen;
    }

    public boolean isUseQuickForm() {
        return this.useQuickForm;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public static class Builder {
        private boolean showWelcomeScreen = true;
        private boolean useQuickForm = false;
        private List<String> fields = Collections.emptyList();

        public Builder showWelcomeScreen(boolean showWelcomeScreen) {
            this.showWelcomeScreen = showWelcomeScreen;
            return this;
        }

        public Builder useQuickForm(boolean useQuickForm) {
            this.useQuickForm = useQuickForm;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UserPreferences build() {
            return new UserPreferences(this.showWelcomeScreen, this.useQuickForm, this.fields);
        }
    }
}

