AJS.test.require("com.atlassian.jira.jira-projects-plugin:browseproject",function(){module("Util.selectedTab");test("sets the selected tab in the query string of the specified url",function(){var b="http://jira.address/context/browse/PROJ/?selectedTab=old-tab:value";var c="new-tab:value";var a=JIRA.Projects.Util.setSelectedTab(b,c);equal(a,"?selectedTab=new-tab:value")});test("sets the selected tab in the query string when there is no query string",function(){var b="http://jira.address/context/browse/PROJ/";var c="new-tab-value";var a=JIRA.Projects.Util.setSelectedTab(b,c);equal(a,"?selectedTab=new-tab-value")});test("sets the selected tab in the query string when there is an empty query string",function(){var b="http://jira.address/context/browse/PROJ/?";var c="new-tab-value";var a=JIRA.Projects.Util.setSelectedTab(b,c);equal(a,"?selectedTab=new-tab-value")});test("sets the selected tab in the query string preserving values to the right",function(){var b="http://jira.address/context/browse/PROJ/?selectedTab=old-tab-value&id=123";var c="new-tab-value";var a=JIRA.Projects.Util.setSelectedTab(b,c);equal(a,"?selectedTab=new-tab-value&id=123")});test("sets the selected tab in the query string preserving values to the left",function(){var b="http://jira.address/context/browse/PROJ/?id=123&selectedTab=old-tab-value";var c="new-tab-value";var a=JIRA.Projects.Util.setSelectedTab(b,c);equal(a,"?id=123&selectedTab=new-tab-value")});test("extracts selected tab from browse project url",function(){var a="http://jira.address/context/browse/PROJ/?selectedTab=the.current.tab";equal(JIRA.Projects.Util.extractSelectedTab(a),"the.current.tab")});test("selected tab is null when query parameter has no equals or value",function(){var a="http://jira.address/context/browse/PROJ/?selectedTab";equal(JIRA.Projects.Util.extractSelectedTab(a),null)});test("last value is taken when selectedTab appears multiple times",function(){var a="http://jira.address/context/browse/PROJ/?selectedTab=first.value&selectedTab=second.value";equal(JIRA.Projects.Util.extractSelectedTab(a),"second.value")});test("extracts selected tab when there are other query string values after",function(){var a="http://jira.address/context/browse/PROJ/?selectedTab=the.current.tab&id=1";equal(JIRA.Projects.Util.extractSelectedTab(a),"the.current.tab")});test("extracts selected tab when there is a parameter with value selectedTab",function(){var a="http://jira.address/context/browse/PROJ/?foo=selectedTab&selectedTab=the.current.tab";equal(JIRA.Projects.Util.extractSelectedTab(a),"the.current.tab")});test("returns null when selected tab is not present",function(){var a="http://jira.address/context/browse/PROJ/?id=1";equal(JIRA.Projects.Util.extractSelectedTab(a),null)});test("returns null when there is no query string",function(){var a="http://jira.address/context/browse/PROJ/";equal(JIRA.Projects.Util.extractSelectedTab(a),null)});test("extracts selected tab when it is the last string value",function(){var a="http://jira.address/context/browse/PROJ/?precedingKey=precedingValue&selectedTab=the.current.tab";equal(JIRA.Projects.Util.extractSelectedTab(a),"the.current.tab")});test("extracts selected tab when it is between two other querystring parameters",function(){var a="http://jira.address/context/browse/PROJ/?precedingKey=precedingValue&selectedTab=the.current.tab&followingKey=followingValue";equal(JIRA.Projects.Util.extractSelectedTab(a),"the.current.tab")});test("returns null when the key is present in the query string with no value",function(){var a="http://jira.address/context/browse/PROJ/?selectedTab=";equal(JIRA.Projects.Util.extractSelectedTab(a),null)});test("returns null when the key is present in the query string with no value and has another value following",function(){var a="http://jira.address/context/browse/PROJ/?selectedTab=&id=1";equal(JIRA.Projects.Util.extractSelectedTab(a),null)})});