define('jira/projects/unlicensed/view/renderer', function() {

    var template = JIRA.Projects.Unlicensed.Templates.unlicensedView;
    var templateUsingAppName = JIRA.Projects.Unlicensed.Templates.unlicensedViewUsingAppName;

    return {
        /**
         * @return {Function} Function that will generate the markup for the unlicensed view using the project type
         * @deprecated using getTemplateUsingAppName instead
         */
        getTemplate: function() {
            return template;
        },

        /**
         * @return {Function} Function that will generate the markup for the unlicensed view using application name
         */
        getTemplateUsingAppName: function() {
            return templateUsingAppName;
        },

        /**
         * @param {Object} templateData - Data to pass to the function
         * @param {string} templateData.projectTypeName - The name of the project type
         * @param {string} templateData.projectTypesInfoUrl - The url to read more about project types
         * @param {string} templateData.projectRedirectUrl - The url to redirect the user to once they click on the call to action button
         * @param {string} templateData.requestLicenseUrl - The url to redirect the user to if they want to request a new license
         * @return {string} The html for the unlicensed view
         * @deprecated use renderUsingAppName instead.
         */
        render: function(templateData) {
            return template({
                projectTypeName: templateData.projectTypeName,
                projectTypesInfoUrl: templateData.projectTypesInfoUrl,
                projectRedirectUrl: templateData.projectRedirectUrl,
                requestLicenseUrl: templateData.requestLicenseUrl
            });
        },

        /**
         * @param {Object} templateData - Data to pass to the function
         * @param {string} templateData.applicationName - The application name
         * @param {string} templateData.projectTypesInfoUrl - The url to read more about project types
         * @param {string} templateData.projectRedirectUrl - The url to redirect the user to once they click on the call to action button
         * @param {string} templateData.requestApplicationAccessUrl - The url to redirect the user to if they want to request application access
         * @param {string} templateData.projectErrorTitle The title of the error message displayed to the user
         * @param {string} templateData.projectErrorContent - The error message displayed to the user
         * @return {string} The html for the unlicensed view
         */
        renderUsingAppName: function(templateData) {
            return templateUsingAppName({
                applicationName: templateData.applicationName,
                projectTypesInfoUrl: templateData.projectTypesInfoUrl,
                projectRedirectUrl: templateData.projectRedirectUrl,
                requestApplicationAccessUrl: templateData.requestApplicationAccessUrl,
                projectErrorTitle: templateData.projectErrorTitle,
                projectErrorContent: templateData.projectErrorContent
            });
        }
    };
});