AJS.test.require("com.atlassian.jira.jira-projects-plugin:subnavigator-test", function() {
    "use strict";

    var ITEM_1 = { id: "item1", label: "Item 1", description: "Item 1"};
    var ITEM_2 = { id: "item2", label: "Item 2", description: "Item 2" };
    var ITEMS = [[ITEM_1], [ITEM_2]];

    module("JIRA.Projects.Subnavigator.View.Title", {
        setup: function() {
            this.$el = AJS.$("<div/>");
            this.model = new JIRA.Projects.Subnavigator.Entities.Items({itemGroups: ITEMS});
            this.view = new JIRA.Projects.Subnavigator.Views.Title({
                el: this.$el,
                model: this.model
            });
        }
    });

    test("Uses the label of the selected item to render the title", function() {
        this.model.selectItem(ITEM_2.id);

        var viewData = this.view.serializeData();

        equal(viewData.title, ITEM_2.label);
    });
});
