AJS.test.require("com.atlassian.jira.jira-projects-plugin:subnavigator-test", function() {
    "use strict";

    var ITEM_1 = { id: "item1", label: "Item 1", description: "Item 1"};
    var ITEM_2 = { id: "item2", label: "Item 2", description: "Item 2" };
    var ITEMS = [[ITEM_1], [ITEM_2]];

    var ID = "id";

    module("JIRA.Projects.Subnavigator.View.StaticTrigger", {
        setup: function() {
            this.$el = AJS.$("<div/>");
            this.model = new JIRA.Projects.Subnavigator.Entities.Items({itemGroups: ITEMS});
            this.view = new JIRA.Projects.Subnavigator.Views.StaticTrigger({
                el: this.$el,
                model: this.model,
                id: ID,
                label: "This is a test"
            });
        }
    });

    test("Renders an static text", function() {
        var viewData = this.view.serializeData();

        equal(viewData.label, "This is a test");
    });

    test("Renders as a button", function() {
        var viewData = this.view.serializeData();

        strictEqual(viewData.renderAsButton, true);
    });

    test("Uses the given id as a suffix when rendering the template", function() {
        this.view.render();

        ok(this.$el.find("#subnav-trigger-" + ID).length === 1);
    });
});
