AJS.test.require("com.atlassian.jira.jira-projects-plugin:subnavigator-test", function() {
    "use strict";

    var ITEM_1 = { id: "item1", label: "Item 1" };
    var ITEM_2 = { id: "item2", label: "Item 2" };

    var ITEMS = [[ITEM_1], [ITEM_2]];

    function listener() {
        return _.extend({}, Backbone.Events);
    }

    module("JIRA.Projects.Subnavigator.Entities.Items", {
        setup: function() {
            this.model = new JIRA.Projects.Subnavigator.Entities.Items({});
        }
    });

    test("Is empty when given list of items is undefined", function() {
        this.model.set("itemGroups", undefined);

        strictEqual(this.model.isEmpty(), true);
    });

    test("Is empty when given list of items is empty", function() {
        this.model.set("itemGroups", []);

        strictEqual(this.model.isEmpty(), true);
    });

    test("Is not empty when the list of items contains something", function() {
        this.model.set("itemGroups", ["item1"]);

        strictEqual(this.model.isEmpty(), false);
    });

    test("Keeps a reference to the selected item when there is one with the given id", function() {
        this.model.set("itemGroups", ITEMS);

        this.model.selectItem(ITEM_2.id);

        equal(this.model.get("selectedItem"), ITEM_2);
    });

    test("Sets the selected item to the first one if there is no item with the given id", function() {
        this.model.set("itemGroups", ITEMS);

        this.model.selectItem("nonexistentItem");

        equal(this.model.get("selectedItem"), ITEM_1);
    });

    test("Sets the selected item to undefined if there is no item with the given id and the list of items is empty", function() {
        this.model.set("itemGroups", []);

        this.model.selectItem(ITEM_1.id);

        equal(this.model.get("selectedItem"), undefined);
    });

    test("Sets the selected item to undefined if there is no item with the given id and the list of items is undefined", function() {
        this.model.set("itemGroups", undefined);

        this.model.selectItem(ITEM_1.id);

        equal(this.model.get("selectedItem"), undefined);
    });

    test("Triggers a 'change:selectedItem' event when an item is selected", function() {
        var spy = this.spy();

        listener().listenTo(this.model, "change:selectedItem", spy);

        this.model.set("itemGroups", ITEMS);

        this.model.selectItem(ITEM_2.id);

        sinon.assert.calledOnce(spy);
    });

    test("Returns a flat version of the items list when asked for all items", function() {
        this.model.set("itemGroups", ITEMS);

        var allItems = this.model.getAllItems();

        deepEqual(allItems, [ITEM_1, ITEM_2]);
    });
});
