/*
* This test file contains tests for Pinned.js and ListView.js.
* Listview.js just has lists, while Pinned.js has both lists and buttons. That's why Pinned.js will have all tests
* of Listview.js. There are some tests which need lists and buttons, so if I put the tests of lists in 2 files, there
* will be many duplicated tests
*/

AJS.test.require("com.atlassian.jira.jira-projects-plugin:pinnablenavigator-test", function() {
    "use strict";

    var ITEM_1 = { id: "item1", label: "Item 1", description: "Item 1" };
    var ITEM_4 = { id: "item4", label: "Item 4", description: "Item 4", count: 5 };
    var LONGLIST = [ITEM_1,ITEM_4,ITEM_1,ITEM_4,ITEM_1,ITEM_4,ITEM_1,ITEM_4,ITEM_4,ITEM_4];



    window.AJS.DarkFeatures = window.AJS.DarkFeatures || {};
    window.AJS.DarkFeatures.isEnabled = function () {
        return true;
    };

    function listener() {
        return _.extend({}, Backbone.Events);
    }

    module("JIRA.Projects.PinnableNavigator.Views.Search.Search", {
        setup: function() {
            this.$el = AJS.$("<div class='js-subnav-search-block'></div>");
            AJS.$('#qunit-fixture').append(this.$el);

            this.clock = sinon.useFakeTimers();

            this.model = new JIRA.Projects.PinnableNavigator.Entities.Items({itemGroups: [{items: LONGLIST}]});
            this.view = new JIRA.Projects.PinnableNavigator.Views.Search.Search({
                searchPlaceHolder: "Search here",
                el: this.$el,
                model: this.model
            });
        },
        teardown: function() {
            this.$el.remove();
            this.clock.restore();
        }
    });

    test("If there are more than ten items and com.atlassian.jira.projects.PinnableNavigator.Search key is enabled, we can do searching", function() {
        ok(this.view.isSearchable(), "Expect the search is unlocked");
    });

    test("If there aren't enough ten items, we block the search", function() {
        this.view.model.set("itemGroups", [
            {
                items: [ITEM_1]
            }
        ]);
        ok(!this.view.isSearchable(), "Expect the search is locked");
    });

    test("Get or clear the query string", function() {
        var query = "query";
        this.view.render();
        this.view.ui.searchInput.val(query);
        ok(this.view.getQuery() === query, "Expect we can get the current query string");

        var spy = this.spy();
        listener().listenTo(this.view, "doQuery", spy);

        this.view.clearQuery();
        ok(this.view.getQuery() === "", "Expect the query string is empty");

        this.clock.tick(1);
        sinon.assert.calledOnce(spy);
    });

    test("If the query string is not null, we show the clear icon and hide the search icon", function() {
        var query = "query";
        this.view.render();

        ok(!this.view.ui.searchIcon.hasClass("hidden"), "Expect that search icon is shown");
        ok(this.view.ui.clearIcon.hasClass("hidden"), "Expect that search icon is hidden");

        var spy = this.spy();
        listener().listenTo(this.view, "doQuery", spy);

        this.view.ui.searchInput.val(query).trigger("keydown");
        this.clock.tick(1);

        sinon.assert.calledOnce(spy);

        ok(this.view.ui.searchIcon.hasClass("hidden"), "Expect that search icon is hidden");
        ok(!this.view.ui.clearIcon.hasClass("hidden"), "Expect that search icon is shown");
    });
});
