(function(){
    "use strict";

    AJS.namespace("JIRA.Projects.PinnableNavigator.Views.NavigatorView.UnpinnedView");

    JIRA.Projects.PinnableNavigator.Views.NavigatorView.UnpinnedView = JIRA.Projects.PinnableNavigator.Views.NavigatorView.NavigatorView.extend({
        template: JIRA.Projects.PinnableNavigator.Templates.unpinned,

        initialize: function() {
            this.listItemsView = new JIRA.Projects.PinnableNavigator.Views.ListView.UnpinnedListView({
                model: this.options.model,
                id: this.options.id || "",
                title: this.options.title,
                manageText: this.options.manageText,
                manageLocation: this.options.manageLocation,
                emptyText: this.options.emptyText,
                tooltipTimeout: this.options.tooltipTimeout,
                searchView: this.options.searchView
            });

            this.listenTo(this.listItemsView, "itemSelected", function(data){
                this.trigger("itemSelected", data);
            });
        },
        //Add the list to this component
        putListintoView: function(){
            this.listItemsView.setElement(this.$(".js-unpinned-items-list"));
            this.renderList();
        }
    });
}());