(function(){
    "use strict";

    AJS.namespace("JIRA.Projects.PinnableNavigator.Views.NavigatorView.NavigatorView");

    JIRA.Projects.PinnableNavigator.Views.NavigatorView.NavigatorView = JIRA.Projects.Libs.Marionette.ItemView.extend({
        ui: {
            manageButton: ".js-manage-button",
            unPinToggler: ".js-unpin-button",
            pinToggler: ".js-pin-toggler"
        },

        triggers: {
            "click @ui.unPinToggler": {
                event: "navigatorUnPinned",
                preventDefault: true,
                stopPropagation: false
            },
            "click @ui.pinToggler": {
                event: "navigatorPinned",
                preventDefault: true,
                stopPropagation: false
            },
            "click @ui.manageButton": {
                event: "manageDialogOpened",
                preventDefault: true,
                stopPropagation: false
            }
        },

        renderSearch: function () {
            if (this.options.searchView && this.options.searchView.isSearchable()) {
                this.options.searchView.setElement(AJS.$(this.options.searchView.options.el));
                this.options.searchView.render();
            }
        },

        //Just update the list, no need to re-render hold control
        renderList: function(){
            this.listItemsView.render();
        },

        isAttachedToDom: function () {
            return !!this.$el.closest("body").length;
        },

        serializeData: function() {
            return {
                idSuffix: this.options.id || ""
            };
        },

        onRender: function() {
            this.unwrapTemplate();
        }
    });
}());