(function(){
    "use strict";

    AJS.namespace("JIRA.Projects.PinnableNavigator.Views.Trigger");

    JIRA.Projects.PinnableNavigator.Views.Trigger = JIRA.Projects.Libs.Marionette.ItemView.extend({
        template: JIRA.Projects.PinnableNavigator.Templates.unpinnedTrigger,

        serializeData: function() {
            // Always show the button, so user can open dropdown menu and add more items
            var selectedItem = this.model.get("selectedItem");
            var switchText = AJS.I18n.getText("project.subnavigator.manage.switch");
            var label = selectedItem ? selectedItem.label : switchText;
            if (this.options.label) {
                label = switchText + ' ' + this.options.label;
            }
            return {
                label: label,
                idSuffix: this.options.id || ""
            };
        },
        onRender: function() {
            this.unwrapTemplate();
        }
    });

}());