(function($){
    "use strict";

    AJS.namespace("JIRA.Projects.PinnableNavigator.ManageDialog.Views.Dialog");

    JIRA.Projects.PinnableNavigator.ManageDialog.Views.Dialog = JIRA.Projects.Libs.Marionette.ItemView.extend({
        template: JIRA.Projects.PinnableNavigator.ManageDialog.Templates.dialog,
        tagName: "section",
        attributes: {
            "class": "aui-layer aui-dialog2 aui-dialog2-small manage-subnav-dialog",
            "aria-hidden": true,
            "role": "dialog",
            "data-aui-modal": true
        },
        ui: {
            loading: ".js-manage-save-spinner",
            saveButton: ".js-manage-save-button",
            cancelButton: ".js-manage-cancel-button",
            deleteButton: ".js-manage-item-delete-button button",
            manageItem: ".js-manage-item",
            manageDialogContents: ".js-manage-contents",
            itemSections: ".js-item-section"
        },
        triggers: {
            "click @ui.cancelButton": {
                event: "closePopup",
                preventDefault: true,
                stopPropagation: false
            }
        },
        events: {
            // event used for testing
            "moveToEnd @ui.manageItem" : function (e) {
                var $target = this.$(e.currentTarget);
                $target.appendTo($target.parent());
            },

            "click @ui.deleteButton": function(e) {
                e.preventDefault();
                var $currentEl = this.$(e.currentTarget);
                var $elNeedToBeDeleted = $currentEl.parents("tr");
                //Remove out of DOM
                $elNeedToBeDeleted.addClass("js-deleted hidden");
                this.checkRemainItems();
            },
            "click @ui.saveButton": function(e) {

                this.showLoading();

                var modifications = this.ui.itemSections.map(function () {
                    var $this = $(this);

                    // Get the deleted items list
                    var deletedItems = _.map($this.find(".js-deleted"), function(item){
                        return $(item).data("id");
                    });
                    // Get the remained items list after deleting some items
                    var itemOrder = _.map($this.find("tr:not(.js-deleted)"), function (item) {
                        return $(item).data("id");
                    });

                    return {
                        id: $this.data("id"),
                        deleted: deletedItems,
                        order: itemOrder
                    };
                });

                this.model.save(modifications)
                    .done(_.bind(function(newData){
                        this.trigger("closePopup", newData);
                    },this))
                    .fail(_.bind(function(error){
                        var errorHolder = this.$(".error-wrapper");
                        errorHolder.html("");
                        AJS.messages.error(errorHolder, {
                            "closeable": false,
                            "body": error.statusText
                        });
                    },this)).always(_.bind(function(){
                        this.stopLoading();
                    },this));

                e.preventDefault();
            }
        },
        onRender: function(){
            this.$(".js-sortable-items").sortable({
                placeholder: "item-holder-highlight item-row js-manage-item",
                sort: function( event, ui ) {
                    ui.placeholder.html(ui.helper.html());
                }
            });
        },
        checkRemainItems: function(){
            if(this.$(".js-manage-item").length <= this.$(".js-deleted").length) {
                this.ui.manageDialogContents.append(JIRA.Projects.PinnableNavigator.ManageDialog.Templates.emptyText({
                    text: this.options.emptyText
                }));
            } else {
                this.$(".js-empty").remove();
            }
        },
        showLoading: function(){
            this.ui.loading.spin();
        },
        stopLoading: function(){
            this.ui.loading.spinStop();
        },
        serializeData: function() {
            var itemGroups = this.model.getManageableItemGroups();
            return {
                itemGroups: itemGroups,
                title: this.options.title,
                manageText: this.options.manageText
            };
        }
    });
}(AJS.$));
