AJS.test.require("com.atlassian.jira.jira-projects-plugin:pinnablenavigator-test",function(){var e={id:"item1",label:"Item 1"};var d={id:"item2",label:"Item 2"};var b={id:"item3",label:"Item 3"};var c=[{items:[e],id:"group1"},{items:[d],id:"group2"}];var a=[{items:[e]},{items:[d]},{items:[b],type:"buttons"}];function f(){return _.extend({},Backbone.Events)}module("JIRA.Projects.PinnableNavigator.Entities.Items",{setup:function(){this.model=new JIRA.Projects.PinnableNavigator.Entities.Items({})}});test("Is empty when given list of items is undefined",function(){this.model.set("itemGroups",undefined);strictEqual(this.model.isEmpty(),true)});test("Is empty when given list of items is empty",function(){this.model.set("itemGroups",[]);strictEqual(this.model.isEmpty(),true)});test("Is not empty when the list of items contains something",function(){this.model.set("itemGroups",["item1"]);strictEqual(this.model.isEmpty(),false)});test("Keeps a reference to the selected item when there is one with the given id",function(){this.model.set("itemGroups",c);this.model.selectItem(d.id);equal(this.model.get("selectedItem"),d)});test("Sets the selected item to the first one if there is no item with the given id",function(){this.model.set("itemGroups",c);this.model.selectItem("nonexistentItem");equal(this.model.get("selectedItem"),e)});test("Sets the selected item to undefined if there is no item with the given id and the list of items is empty",function(){this.model.set("itemGroups",[]);this.model.selectItem(e.id);equal(this.model.get("selectedItem"),undefined)});test("Sets the selected item to undefined if there is no item with the given id and the list of items is undefined",function(){this.model.set("itemGroups",undefined);this.model.selectItem(e.id);equal(this.model.get("selectedItem"),undefined)});test("Triggers a 'change:selectedItem' event when an item is selected",function(){var g=this.spy();f().listenTo(this.model,"change:selectedItem",g);this.model.set("itemGroups",c);this.model.selectItem(d.id);sinon.assert.calledOnce(g)});test("Returns a flat version of the items list when asked for all items",function(){this.model.set("itemGroups",c);var g=this.model.getAllItems();deepEqual(g,[e,d])});test("Returns all real items (except buttons such as New Queue or New Report)",function(){this.model.set("itemGroups",a);var g=this.model.getAllItemsExceptButtons();deepEqual(g,[e,d])});test("Returns all items which match with given name",function(){this.model.set("itemGroups",a);var g=this.model.getAllItemsWithName("item 2");deepEqual(g,[{items:[d]},{items:[b],type:"buttons"}])});test("Test not manageable if no items in manageble group",function(){this.model.set("itemGroups",[{allowDelete:true,items:[]},{items:[e]}]);ok(!this.model.isManageable(),"Expected group not to be manageable")});test("Test not manageable if no allowDelete or allowReorder",function(){this.model.set("itemGroups",[{items:[]},{items:[e]}]);ok(!this.model.isManageable(),"Expected group not to be manageable")});test("Test is manageable",function(){this.model.set("itemGroups",[{items:[]},{allowDelete:true,items:[e]}]);ok(this.model.isManageable(),"Expected group to be manageable")});test("Test hasDisplayableGroups",function(){this.model.set("itemGroups",[{items:[]}]);ok(!this.model.hasDisplayableGroups());this.model.set("itemGroups",[{emptyText:"empty",items:[]}]);ok(this.model.hasDisplayableGroups());this.model.set("itemGroups",[{items:[e]}]);ok(this.model.hasDisplayableGroups())})});