(function() {
    "use strict";

    AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter');

    JIRA.Projects.Sidebar.ScopeFilter.Model = function(data) {
        this.selectedScope = data.selectedScope;
        this.createScopeActions = data.createScopeActions;

        if(this.selectedScope) {
            this.selectableScopes = _.reject(data.scopes, function(scope) {
                return scope.label === this.selectedScope.label && scope.link === this.selectedScope.link;
            }, this);
        } else {
            this.selectableScopes = data.scopes;
        }

        var userCanCreateAScope = this.createScopeActions.length > 0;
        var thereAreScopesToSelect = this.selectableScopes.length > 0;
        this.displayWhenSidebarIsCollapsed = userCanCreateAScope || thereAreScopesToSelect;
    };

    JIRA.Projects.Sidebar.ScopeFilter.Model.prototype.getSelectedScope = function() {
        return this.selectedScope
    };

    JIRA.Projects.Sidebar.ScopeFilter.Model.prototype.getSelectableScopes = function() {
        return this.selectableScopes;
    };

    JIRA.Projects.Sidebar.ScopeFilter.Model.prototype.getCreateScopeActions = function() {
        return this.createScopeActions;
    };

    JIRA.Projects.Sidebar.ScopeFilter.Model.prototype.shouldDisplayWhenSidebarIsCollapsed = function() {
        return this.displayWhenSidebarIsCollapsed;
    }
})();
