(function() {
    "use strict";

    AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter');

    function createCollapsedScopeFilterContainer($sidebarContentContainer) {
        var $collapsedSidebarContainer = AJS.$(JIRA.Projects.Sidebar.ScopeFilter.Templates.collapsedContainer());
        $sidebarContentContainer.prepend($collapsedSidebarContainer);
        return $collapsedSidebarContainer;
    }

    function listenToSidebarEvents(sidebar, collapsedScopeFilterController) {
        sidebar.on('collapse-start', function() {
            collapsedScopeFilterController.render();
            JIRA.trace("sidebar.scopefilter.collapsed");
        });

        sidebar.on('expand-end', function() {
            collapsedScopeFilterController.remove();
        });
    }

    JIRA.Projects.Sidebar.ScopeFilter.CollapsedInitializer = JIRA.Projects.Libs.Marionette.Controller.extend({
        initialize: function(options) {
            this.sidebarAPI = options.sidebarAPI;
            this.scopeFilterData = options.scopeFilterData;
            this.sidebar = options.sidebar;
            this.$sidebarContentContainer = options.$sidebarContentContainer;
        },

        run: function() {
            if(!this.sidebarAPI.isProjectSidebar()) {
                return;
            }

            var scopeFilter = new JIRA.Projects.Sidebar.ScopeFilter.Model(this.scopeFilterData);
            if(!scopeFilter.shouldDisplayWhenSidebarIsCollapsed()) {
                return;
            }

            var $collapsedSidebarContainer = createCollapsedScopeFilterContainer(this.$sidebarContentContainer);
            var collapsedScopeFilterController = new JIRA.Projects.Sidebar.ScopeFilter.CollapsedController({
                scopeFilter: scopeFilter,
                collapsedScopeFilterContainer: $collapsedSidebarContainer
            });
            listenToSidebarEvents(this.sidebar, collapsedScopeFilterController);
            if (this.sidebar.isCollapsed()) {
                collapsedScopeFilterController.render();
            }
        }
    });
})();