(function () {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.Reports");

    JIRA.Projects.Sidebar.Reports = {
        storeLastViewedReportLink: function(reportUrl) {
            if (JIRA.API.Sidebar.isProjectSidebar()) {
                var key = this._createLastViewedReportKey();
                require("jira/data/local-storage").setItem(key, reportUrl);
                this._setReportsItemLink(reportUrl);
            }
            JIRA.trace("jira.projects.sidebar.reports.link.stored");
        },

        restoreLastViewedReportLink: function() {
            if (JIRA.API.Sidebar.isProjectSidebar()) {
                var key = this._createLastViewedReportKey();
                var reportUrl = require("jira/data/local-storage").getItem(key);
                if (reportUrl) {
                    this._setReportsItemLink(reportUrl);
                }
            }
            JIRA.trace("jira.projects.sidebar.reports.link.restored");
        },

        _createLastViewedReportKey: function() {
            var scopeFilterId = JIRA.API.Sidebar.getSelectedScopeFilterId();
            var projectKey = JIRA.API.Projects.getCurrentProjectKey();

            var key = "last.viewed.report." + projectKey;
            if (scopeFilterId) {
                key += "." + scopeFilterId;
            }
            return key;
        },

        _setReportsItemLink: function(reportUrl) {
            JIRA.API.Sidebar.setReportsItemLink(reportUrl);
        }
    };

}());
