(function($) {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Views.Shortcut");
    JIRA.Projects.Sidebar.ProjectShortcuts.Views.Shortcut = JIRA.Projects.Libs.Marionette.ItemView.extend({
        template: JIRA.Projects.Sidebar.ProjectShortcuts.Templates.shortcut,
        initialize: function initialize() {
            _.bindAll(this, 'toggleDropdown');
            this.iconFactory = JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons;
        },
        ui: {
            del: '.project-shortcuts-group__actions__delete',
            edit: '.project-shortcuts-group__actions__edit',
            trigger: '.project-shortcuts-group__actions',
            dropdown: '.project-shortcuts-group__dropdown',
            link: '.project-shortcuts-group__link'
        },
        modelEvents: {
            'change': 'render'
        },
        events: {
            'click @ui.link': function onLinkClick() {
                this.trigger('click:link', this.model);
            }
        },
        onRender: function() {
            var instance = this;
            this.unwrapTemplate();
            var $window = $(window);
            var $sidebarBody = $('.aui-sidebar-body');

            this.ui.edit.on('click', function onEdit(e) {
                e.preventDefault();
                instance.ui.trigger.blur();
                var editDialog = new JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Edit({
                    model: instance.model
                });
                instance.trigger('edit:open', instance.model);
                
                instance.listenToOnce(editDialog, 'dialog:close', function onDialogClosed(isSave) {
                    instance.trigger('edit:close', instance.model, isSave);
                });
            });
            this.ui.del.on('click', function onDelete(e) {
                e.preventDefault();
                instance.ui.trigger.blur();
                var deleteDialog = new JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Delete({
                    model: instance.model
                });
            });
            this.ui.dropdown.on({
                "aui-dropdown2-show": function() {
                    instance.$el.addClass('aui-nav-selected');
                    $sidebarBody.one('scroll', instance.toggleDropdown);
                    $window.one('scroll', instance.toggleDropdown);
                    // focus on trigger, so it handle all keyboard events
                    instance.ui.trigger.focus();
                },
                "aui-dropdown2-hide": function() {
                    instance.$el.removeClass('aui-nav-selected');
                    $sidebarBody.off('scroll', instance.toggleDropdown);
                    $window.off('scroll', instance.toggleDropdown);
                }
            });
        },

        serializeData: function () {
            var data = _.extend(this.model.toJSON(), {
                canManage: true,
                isWithIcon: this.iconFactory.isWithIcons()
            });
            if (this.iconFactory.isWithIcons()) {
                data = _.extend(data, {
                    iconsMap: JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons.getIconsMap()
                });
            }

            return data;
        },
        toggleDropdown: function toggleDropdown() {
            this.ui.trigger.trigger("aui-button-invoke");
        }
    });

})(AJS.$);