(function ($) {
    "use strict";

    var dataIconId = 'projectShortcutsIconsId';
    var activeAUIDropdown2ElementClass = 'active aui-dropdown2-active';

    function changeIconSelectionOnKeyboardEvent(instance, event) {
        var elementsInRow = 5;

        var active = instance.ui.iconList.find('.active');
        var iconsListLength = instance.ui.iconList.find('li').size();
        var step;

        switch (event.keyCode) {
            case AJS.keyCode.LEFT:
                step = -1;
                break;
            case AJS.keyCode.RIGHT:
                step = 1;
                break;
            case AJS.keyCode.DOWN:
                step = elementsInRow;
                break;
            case AJS.keyCode.UP:
                step = -elementsInRow;
                break;
            default :
                step = 0;
        }

        var newActiveElementIndex = active.closest('li').index() + step;
        if (newActiveElementIndex < 0 || newActiveElementIndex >= iconsListLength) {
            newActiveElementIndex += iconsListLength;
            newActiveElementIndex %= iconsListLength;
        }

        active.removeClass(activeAUIDropdown2ElementClass);
        instance.ui.icon.eq(newActiveElementIndex).addClass(activeAUIDropdown2ElementClass);
    }

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Views.IconPickerContent");
    JIRA.Projects.Sidebar.ProjectShortcuts.Views.IconPickerContent = JIRA.Projects.Libs.Marionette.ItemView.extend({

        template: JIRA.Projects.Sidebar.ProjectShortcuts.Templates.iconsPicker,

        ui: {
            icon: ".project-shortcuts-icons-icon",
            iconList: ".project-shortcuts-icons-list",
            iconPicker: ".project-shortcuts-icons-picker"
        },

        modelEvents: {
            "change:icon": function changeCurrentIcon() {
                var icon = this._modelIcon();
                var children = this.ui.iconPicker.children();

                children.removeClass(this.iconFactory.getAllIconsClasses());
                children.addClass(icon.className);
                this.ui.iconPicker.data(dataIconId, icon.name);
            },

            "save:start": function saveStarted() {
                this.ui.iconPicker.attr("aria-disabled", true);
            },

            "save:finish": function saveFinish() {
                this.ui.iconPicker.attr("aria-disabled", false);
            }
        },

        events: {
            "keydown @ui.iconPicker": function pickerMovement(e) {
                if (!this.isPickerActive()) {
                    return;
                }

                switch(e.keyCode) {
                    case AJS.keyCode.LEFT:
                    case AJS.keyCode.RIGHT:
                    case AJS.keyCode.DOWN:
                    case AJS.keyCode.UP:
                        changeIconSelectionOnKeyboardEvent(this, e);
                        e.stopPropagation();
                        e.preventDefault();

                        this.ui.iconList.trigger("aui-dropdown2-item-selected");
                        break;

                    case AJS.keyCode.ESCAPE:
                        this.hideIconPicker();

                        e.stopPropagation();
                        e.preventDefault();

                        break;
                }
            }
        },

        initialize: function(options) {
            this.iconFactory = JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons;
            this.analytics = JIRA.Projects.Sidebar.ProjectShortcuts.Analytics;
        },

        onRender: function() {
            var instance = this;

            this.ui.icon.on("click", function iconClicked() {
                var iconName = $(this).data(dataIconId);

                instance.analytics.iconChangeConfirmed(instance.model, iconName);
                instance.analyticsOldIconId = '';
                instance.analyticsIconClicked = true;
                instance.model.set("icon", iconName);

                instance.ui.iconPicker.focus();
            });

            this.ui.iconList.on("aui-dropdown2-show", function () {
                instance.ui.iconPicker.focus();
                instance.analyticsIconClicked = false;
                instance.analytics.iconPickerOpened(instance.model);
            });

            this.ui.iconList.on("aui-dropdown2-hide", function() {
                instance.analytics.iconPickerClosed(instance.model, instance.analyticsIconClicked);
            });

            // analytics on icon change - include old icon
            this.analyticsOldIconId = '';
            this.ui.iconList.on("aui-dropdown2-item-selected", function(e) {
                var id = AJS.$(this).find(".active").data(dataIconId);
                if (instance.analyticsOldIconId && instance.analyticsOldIconId !== id) {
                    instance.analytics.iconChanged(instance.model, id, instance.analyticsOldIconId);
                }
                instance.analyticsOldIconId = id;
            });

            this.ui.iconPicker.data(dataIconId, this.model.get("icon"));
        },

        hideIconPicker: function() {
            if (this.isPickerActive()) {
                this.ui.iconPicker.trigger('aui-button-invoke');
            }
        },

        isPickerActive: function () {
            return this.ui.iconPicker.hasClass('active');
        },

        _modelIcon: function getIconElement() {
            return this.iconFactory.getIconFromName(this.model.get('icon'));
        },

        onFormSubmit: function setIconInModel() {
            this.model.set("icon", this.ui.iconPicker.data(dataIconId) || "");
        },

        focus: function focusOnPicker() {
            this.ui.iconPicker.focus();
        },

        serializeData: function() {
            return {
                iconsList: this.iconFactory.getIconsList(),
                icon: this._modelIcon(),
                cid: this.cid
            }
        }

    });
})(AJS.$);