AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"],function(){module("JIRA.Projects.Sidebar.ProjectShortcuts.Views.DialogContent",{setup:function(){this.mockModel=new Backbone.Model();this.mockModel.save=sinon.stub();this.mockModel.clear=sinon.stub();this.mockModel.set({name:"",icon:"",url:""});this.mockErrorModel=new Backbone.Model();this.view=new JIRA.Projects.Sidebar.ProjectShortcuts.Views.DialogContent({template:JIRA.Projects.Sidebar.ProjectShortcuts.Templates.addDialog,model:this.mockModel,errorModel:this.mockErrorModel});this.initializeIcons();this.view.render()},stubSerializeData:function(){this.stub(JIRA.Projects.Libs.Marionette.ItemView.prototype,"serializeData").returns({})},expectNameValueOnUrlBlur:function(b,a){this.view.ui.url.val(b);this.view.ui.url.trigger("blur");equal(this.view.ui.name.val(),a)},initializeIcons:function(){var b=[];for(var a=0;a<10;a++){b.push({className:"class"+a,name:"name"+a})}JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons.initialize(b);JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons.setWithIcons(true)}});test("Should disable all inputs and show spinner when save starts.",function(){this.mockModel.trigger("save:start");ok(this.view.$(":input").is(":disabled"));ok(this.view.ui.submit.hasClass("loading"));equal(this.view.ui.submit.find(".spinner").length,1)});test("Should enable all inputs and hide spinner when save finishes.",function(){this.mockModel.trigger("save:start");this.mockModel.trigger("save:finish");ok(this.view.$(":input").is(":enabled"));ok(!this.view.$("#project-shortcuts-submit").hasClass("loading"));equal(this.view.$("#project-shortcuts-submit .spinner").length,0)});test("Should render field errors when save fails.",function(){this.stubSerializeData();this.mockErrorModel.set({urlError:"url error",nameError:"name error"});this.mockModel.trigger("save:failure");equal(this.view.$(".error").length,2);equal(this.view.$(".error:first").text(),"url error");equal(this.view.$(".error:last").text(),"name error")});test("Should show global error flag when save fails.",function(){this.stubSerializeData();var a=sinon.stub();this.stub(window,"require").withArgs("aui/flag").returns(a);this.mockErrorModel.set("generalError","auth error");this.mockModel.trigger("save:failure");sinon.assert.calledOnce(a);sinon.assert.calledWith(a,{type:"error",title:"project.shortcuts.dialog.error.general.save",close:"auto",body:"auth error"});this.mockErrorModel.set("generalError","global error");this.mockModel.trigger("save:failure");sinon.assert.calledTwice(a);sinon.assert.calledWith(a,{type:"error",title:"project.shortcuts.dialog.error.general.save",close:"auto",body:"global error"})});test("Should clear the model on cancel.",function(){this.view.ui.cancel.click();sinon.assert.calledOnce(this.mockModel.clear)});test("Should replicate name as url after cancel.",function(){this.view.setNameAutomagically=false;this.view.ui.cancel.click();ok(this.view.setNameAutomagically)});test("Should trigger cancel event.",function(){var a=sinon.stub();this.view.on("cancel",a);this.view.ui.cancel.click();sinon.assert.calledOnce(a)});test("Should save the model on form submit.",function(){this.view.ui.url.val("url test");this.view.ui.url.trigger("input");this.view.ui.name.val("name test");this.view.ui.name.trigger("input");this.view.getRegion("iconPicker").currentView.ui.iconPicker.data("projectShortcutsIconsId","icon test");this.view.ui.form.submit();equal(this.mockModel.get("url"),"http://url test");equal(this.mockModel.get("name"),"name test");equal(this.mockModel.get("icon"),"icon test");sinon.assert.calledOnce(this.mockModel.save)});test("Should ensure prefix and automatic label on form submit.",function(){this.view.ui.url.val("test.pl/asd");this.view.ui.form.submit();equal(this.view.ui.url.val(),"http://test.pl/asd");equal(this.view.ui.name.val(),"test.pl")});test("Should add http:// prefix to the url without protocol on blur.",function(){var b=(function(f,d){var e=(d)?notEqual:equal;this.view.ui.url.val(f);this.view.ui.url.trigger("blur");e(this.view.ui.url.val(),f)}).bind(this);var c=function(d){b(d)};var a=function(d){b(d,true)};c("http://test");c("https://test");c("hipchat:test");c("callto:test");c("callto:");c(" callto:");a("www.test.com/x:10");this.view.ui.url.val("url test");this.view.ui.url.trigger("blur");equal(this.view.ui.url.val(),"http://url test")});test("Should set link label to the value of url without prefix and only up to slash.",function(){this.expectNameValueOnUrlBlur("test.pl","test.pl");this.expectNameValueOnUrlBlur("http://test.pl","test.pl");this.expectNameValueOnUrlBlur("callto:test","test");this.expectNameValueOnUrlBlur("test.pl/suffix","test.pl");this.expectNameValueOnUrlBlur(" test.pl/suffix","test.pl");this.expectNameValueOnUrlBlur("http://test.pl/suffix","test.pl");this.expectNameValueOnUrlBlur("http://","");this.expectNameValueOnUrlBlur("callto:","")});test("Should not alter name value if user touched it.",function(){this.expectNameValueOnUrlBlur("test.pl","test.pl");this.view.ui.name.val("changed");this.view.ui.name.trigger("input");this.expectNameValueOnUrlBlur("different.pl","changed")})});