(function() {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons");
    var _iconsList = [];
    var _iconsMap = {};
    var _isWithIcons = false;

    /**
     * Class to manage set of icons that are available for user.
     * Single icon class contains unique icon name and css class which should be rendered.
     */
    JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons = {
        initialize: function(iconList) {
            _iconsList = iconList || _iconsList;
            /**
             * Fix for bug [HIROL-582] Backlog is failing to load for admin when shortcut icons are enabled
             * _.indexBy is available in underscore >= 1.5.2, using 1.4.4 currently
             */
            _iconsMap = {};
            _.each(iconList, function(element) {
                _iconsMap[element.name] = element;
            });
        },
        getIconsList: function() {
            return _iconsList;
        },

        getIconsMap: function() {
            return _iconsMap;
        },

        getAllIconsClasses: function() {
            return _.reduce(_iconsList, function(memo, current){
                return memo + current.className + " ";
            }, "");
        },

        /**
         * Return single icon class from icons set, based on icon name.
         * If icon does not exists (e.g. icons set changed or icon name is empty), returns first icon from set.
         */
        getIconFromName: function(name) {
            if (this.getIconsMap()[name]){
                return this.getIconsMap()[name];
            }
            if (this.getIconsList()[0]) {
                return this.getIconsList()[0];
            }
            return {};
        },

        setWithIcons: function(isWithIcons) {
            _isWithIcons = isWithIcons;
        },
        isWithIcons: function() {
            return _isWithIcons;
        }
    };

})();