JIRA.API.getSidebar().done(function() {

    var projectId = WRM.data.claim('com.atlassian.jira.projects.shortcuts:project-id');
    JIRA.Projects.Sidebar.ProjectShortcuts.Analytics.initialize(projectId);

    // Start everything up only if user can manage project shortcuts
    if (WRM.data.claim('com.atlassian.jira.projects.shortcuts:can-manage')) {

        var isWithIcons = WRM.data.claim('com.atlassian.jira.projects.shortcuts:with-icons');

        if (isWithIcons) {
            JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons.initialize(
                    WRM.data.claim('com.atlassian.jira.projects.shortcuts:icons-list'));
        }
        JIRA.Projects.Sidebar.ProjectShortcuts.Services.AvailableIcons.setWithIcons(isWithIcons);

        var projectKey = JIRA.API.Projects.getCurrentProjectKey();

        var shortcutsCollection = new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcuts(
            WRM.data.claim('com.atlassian.jira.projects.shortcuts:shortcuts'),
            { projectKey: projectKey }
        );

        var shortcutsView = new JIRA.Projects.Sidebar.ProjectShortcuts.Views.List({
            collection: shortcutsCollection,
            targetGroup: 'project-shortcuts-group'
        });
        shortcutsView.render();

        JIRA.Projects.Sidebar.ProjectShortcuts.Analytics.initDialogActions(shortcutsView);
    }

    JIRA.Projects.Sidebar.ProjectShortcuts.Analytics.initShortcutClick('.project-shortcuts-list', '.aui-sidebar');
});