(function () {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Analytics");

    var shortcutLinkSelector = "a.project-shortcuts-group__link";
    var isWithIcons = AJS.DarkFeatures.isEnabled("com.atlassian.jira.projects.ProjectCentricNavigation.ProjectShortcutIcons");

    JIRA.Projects.Sidebar.ProjectShortcuts.Analytics = {
        initialize: function(projectId) {
            this.projectId = projectId;
        },
        
        initShortcutClick: function (shortcutsElement, sidebarElement) {
            var sidebar = AJS.sidebar(sidebarElement);
            var shortcuts = AJS.$(shortcutsElement);
            var instance = this;

            shortcuts.on("click", shortcutLinkSelector, function (e) {
                var shortcutsList = shortcuts.find(shortcutLinkSelector);
                var clickedElement = AJS.$(this);

                AJS.trigger('analyticsEvent', {
                    name: "jira.projects.shortcut.clicked",
                    data: {
                        shortcutId: clickedElement.data("shortcutId"),
                        shortcutPosition: clickedElement.closest("li").index() + 1,
                        shortcutIconName: isWithIcons ? clickedElement.find(".aui-icon").data("projectShortcutsIconId") : "",
                        shortcutCount: shortcutsList.size(),
                        isWithIcons: isWithIcons,
                        isSidebarCollapsed: sidebar.isCollapsed(),
                        projectId: instance.projectId
                    }
                });
            });
        },
        
        initDialogActions: function (shortcutsList) {
            var instance = this;
            
            shortcutsList.on("childview:edit:open", function (view, model) {
                var index = model.collection.indexOf(model) + 1;
                AJS.trigger('analyticsEvent', {
                    name: "jira.projects.shortcut.edit.dialog.opened",
                    data: {
                        isWithIcons: isWithIcons,
                        shortcutId: model.get("id"),
                        shortcutPosition: index,
                        shortcutCount: model.collection.size(),
                        projectId: instance.projectId
                    }
                });
            });
            shortcutsList.on("childview:edit:close", function (view, model, save) {
                var index = model.collection.indexOf(model) + 1;
                AJS.trigger('analyticsEvent', {
                    name: "jira.projects.shortcut.edit.dialog.closed",
                    data: {
                        isWithIcons: isWithIcons,
                        isSave: save,
                        shortcutId: model.get("id"),
                        shortcutPosition: index,
                        shortcutCount: model.collection.size(),
                        projectId: instance.projectId
                    }
                });
            });
            
            shortcutsList.on("add:open", function () {
                AJS.trigger('analyticsEvent', {
                    name: "jira.projects.shortcut.add.dialog.opened",
                    data: {
                        isWithIcons: isWithIcons,
                        projectId: instance.projectId
                    }
                });
            });
            shortcutsList.on("add:close", function (save) {
                AJS.trigger('analyticsEvent', {
                    name: "jira.projects.shortcut.add.dialog.closed",
                    data: {
                        isWithIcons: isWithIcons,
                        isSave: save,
                        projectId: instance.projectId
                    }
                });            
            });
        },

        iconChanged: function (model, iconName, oldIconName) {
            AJS.trigger('analyticsEvent', {
                name: "jira.projects.shortcut.icon.changed",
                data: {
                    iconName: iconName,
                    oldIconName: oldIconName,
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    projectId: this.projectId
                }
            });
        },

        iconChangeConfirmed: function (model, iconName) {
            AJS.trigger('analyticsEvent', {
                name: "jira.projects.shortcut.icon.confirmed",
                data: {
                    oldIconName: model.get("icon"),
                    iconName: iconName,
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    projectId: this.projectId
                }
            });
        },

        iconPickerOpened: function (model) {
            AJS.trigger('analyticsEvent', {
                name: "jira.projects.shortcut.icon.picker.opened",
                data: {
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    projectId: this.projectId
                }
            });
        },

        iconPickerClosed: function (model, save) {
            AJS.trigger('analyticsEvent', {
                name: "jira.projects.shortcut.icon.picker.closed",
                data: {
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    isSave: save,
                    projectId: this.projectId
                }
            });
        }
    };
})();