(function() {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Entities.ShortcutErrors");
    JIRA.Projects.Sidebar.ProjectShortcuts.Entities.ShortcutErrors = Backbone.Model.extend({
        defaults: {
            "urlError": "",
            "nameError": "",
            "iconError": "",
            "generalError": ""
        },
        initialize: function initialize(data, options) {
            var model = options.model;

            this.listenTo(model, "save:failure remove:failure", function failure(errorData) {
                this.set({
                    urlError: errorData.errors && errorData.errors.url,
                    nameError: errorData.errors && errorData.errors.name,
                    iconError: errorData.errors && errorData.errors.icon,
                    generalError: (errorData.message || (errorData.errorMessages && errorData.errorMessages.length > 0))
                        ? errorData.message || errorData.errorMessages[0]
                        : undefined
                });
            });
            this.listenTo(model, "save:success remove:success", this.clear);
        }
    });


})();