AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"],function(){module("JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcut",{setup:function(){this.model=new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcut({id:"1",url:"http://example.com/",name:"Example",icon:"jira"},{projectKey:"TEST"});this.server=sinon.fakeServer.create()},expectSuccessfulRequest:function(){this.server.respondWith(AJS.contextPath()+"/rest/projects/1.0/project/TEST/shortcut/1",[200,{"Content-Type":"application/json"},'{ "id": 1, "url": "http://example.com/response", "name": "Example response", "icon": "Example icon" }'])},expectFailedRequest:function(){this.server.respondWith(AJS.contextPath()+"/rest/projects/1.0/project/TEST/shortcut/1",[400,{"Content-Type":"application/json"},'{ "errors": { "url": "Invalid url", "name": "Invalid name", "icon": "Invalid icon" } }'])},teardown:function(){this.server.restore()}});test("Should throw when initialized without projectKey",function(){raises(function(){new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcut(undefined)},"Project key is required")});test("Should remove id and set url, name and icon to empty string on clear",function(){this.model.clear();equal(this.model.get("id"),undefined);equal(this.model.get("url"),"");equal(this.model.get("name"),"");equal(this.model.get("icon"),"")});test("Should create model when it has no id when saving",function(){var a=this.sandbox.spy(this.model,"sync");this.model.unset("id");this.server.respondWith(AJS.contextPath()+"/rest/projects/1.0/project/TEST/shortcut",[200,{"Content-Type":"application/json"},'{ "id": 1, "url": "http://example.com/response", "name": "Example response", "icon": "Example icon"}']);this.model.save();this.server.respond();sinon.assert.calledWith(a,"create")});test("Should update model when it has id when saving",function(){var a=this.sandbox.spy(this.model,"sync");this.expectSuccessfulRequest();this.model.save();this.server.respond();sinon.assert.calledWith(a,"update")});test("Should trigger save:start event when save request is sent",function(){var a=this.sandbox.spy();this.model.on("save:start",a);this.expectSuccessfulRequest();this.model.save();this.server.respond();sinon.assert.calledOnce(a)});test("Should trigger save:finish and save:success event when save request is successful",function(){var a=this.sandbox.stub();var b=this.sandbox.stub();this.model.on("save:finish",a);this.model.on("save:success",b);this.expectSuccessfulRequest();this.model.save();this.server.respond();sinon.assert.calledOnce(a);sinon.assert.calledOnce(b);sinon.assert.callOrder(a,b)});test("Should trigger save:finish and save:failure event with error details when save request fails",function(){var b=this.sandbox.spy();var a=this.sandbox.spy();this.model.on("save:finish",b);this.model.on("save:failure",a);this.expectFailedRequest();this.model.save();this.server.respond();sinon.assert.calledOnce(b);sinon.assert.calledOnce(a);sinon.assert.calledWith(a,{errors:{url:"Invalid url",name:"Invalid name",icon:"Invalid icon"}});sinon.assert.callOrder(b,a)});test("Should not trigger another save/remove request when one is pending",function(){var a=this.sandbox.spy();this.model.on("save:finish",a);this.expectSuccessfulRequest();this.model.save();this.model.save();this.model.destroy();this.server.respond();sinon.assert.calledOnce(a);equal(this.server.requests.length,1)});test("Should trigger remove:start event when remove request is sent",function(){var a=this.sandbox.spy();this.model.on("remove:start",a);this.expectSuccessfulRequest();this.model.destroy();this.server.respond();sinon.assert.calledOnce(a)});test("Should trigger remove:finish and remove:success event when remove request is successful",function(){var a=this.sandbox.spy();var b=this.sandbox.spy();this.model.on("remove:finish",a);this.model.on("remove:success",b);this.expectSuccessfulRequest();this.model.destroy();this.server.respond();sinon.assert.calledOnce(a);sinon.assert.calledOnce(b);sinon.assert.callOrder(a,b)});test("Should trigger remove:finish and remove:failure event with error details when remove request fails",function(){var b=this.sandbox.spy();var a=this.sandbox.spy();this.model.on("remove:finish",b);this.model.on("remove:failure",a);this.expectFailedRequest();this.model.destroy();this.server.respond();sinon.assert.calledOnce(b);sinon.assert.calledOnce(a);sinon.assert.calledWith(a,{errors:{url:"Invalid url",name:"Invalid name",icon:"Invalid icon"}});sinon.assert.callOrder(b,a)})});