(function($) {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Edit");

    JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Edit = JIRA.Projects.Libs.Marionette.Controller.extend({
        initialize: function(options) {
            var instance = this;
            _.bindAll(this, "hide");

            this.model = new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcut(options.model.toJSON(), {
                projectKey: options.model.projectKey || options.model.collection.projectKey
            });
            this.errorModel = new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.ShortcutErrors(undefined, {
                model: this.model
            });
            this.view = new JIRA.Projects.Sidebar.ProjectShortcuts.Views.EditDialogContent({
                model: this.model,
                errorModel: this.errorModel
            });
            this.analyticsSave = false;

            this.view.render();
            var $dialogElement = $(JIRA.Projects.Sidebar.ProjectShortcuts.Templates.editDialogChrome({}));
            this.view.$el.appendTo($dialogElement);
            this.dialog = AJS.dialog2($dialogElement);
            this.dialog.show();
            this.view.ui.url.focus();

            this._onResizeWindow = function() {
                instance.hideIconPicker();
            };
            $(window).on('resize', this._onResizeWindow);

            this.listenTo(this.view, 'cancel', this.hide);
            this.listenTo(this.model, 'save:success', function onSave() {
                this.analyticsSave = true;
                this.hide();
                options.model.set(instance.model.toJSON());
            });
            this.dialog.on("hide", function onDialogHide() {
                instance.trigger("dialog:close", instance.analyticsSave);
            });
        },

        hideIconPicker: function() {
            this.view.hideIconPicker();
        },

        hide: function hide() {
            this.dialog.hide();
            $(window).off('resize', this._onResizeWindow);
        }
    });

})(AJS.$);