(function($) {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Delete");

    JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Delete = JIRA.Projects.Libs.Marionette.ItemView.extend({
        template: JIRA.Projects.Sidebar.ProjectShortcuts.Templates.deleteDialog,
        ui: {
            inputs: "input, button",
            submit: ".project-shortcuts-submit",
            cancel: ".project-shortcuts-cancel"
        },
        events: {
            "click @ui.cancel": function cancel(e) {
                e.preventDefault();
                this.dialog.hide();
            },
            "click @ui.submit": function formSubmit(e) {
                e.preventDefault();
                this.model.destroy({wait: true});
            }
        },
        modelEvents: {
            "remove:start": function removeStart() {
                this.ui.inputs.prop("disabled", true);
                this.ui.submit.addClass("loading");
                this.ui.submit.spin({className: "spinner"});
            },
            "remove:finish": function removeFinish() {
                this.ui.inputs.prop("disabled", false);
                this.ui.submit.removeClass("loading");
                this.ui.submit.spinStop({className: "spinner"});
                this.dialog.hide();
                JIRA.trace("jira.projects.shortcuts.deleted");
            },
            "remove:failure": function removeFailure(errorData) {
                if (errorData.message || (errorData.errorMessages && errorData.errorMessages.length > 0)) {
                    var flag = require('aui/flag');
                    flag({
                        type: "error",
                        title: AJS.I18n.getText('project.shortcuts.dialog.error.general.delete'),
                        close: "auto",
                        body: errorData.message || errorData.errorMessages[0]
                    });
                }
            }
        },
        initialize: function initialize() {
            this.render();
            this.$el.appendTo("body");

            this.dialog = AJS.dialog2(this.$el);
            this.dialog.show();
            var instance = this;
            this.dialog.on("hide", function() {
                _.defer(function () {
                    instance.destroy();
                });
            });
        },
        onRender: function onRender() {
            this.unwrapTemplate();
        }
    });
})(AJS.$);