(function($) {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Add");

    JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Add = JIRA.Projects.Libs.Marionette.Controller.extend({
        initialize: function(options) {
            _.bindAll(this, "hide", "refresh", "focusForm");
            var instance = this;

            this.analyticsSave = false;

            this.sidebarItem = options.sidebarItem;
            this.projectKey = options.projectKey;
            this.collection = options.collection;
            this.model = new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcut(null, {
                projectKey: this.projectKey
            });
            this.errorModel = new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.ShortcutErrors(null, {
                model: this.model
            });
            this.view = new JIRA.Projects.Sidebar.ProjectShortcuts.Views.AddDialogContent({
                model: this.model,
                errorModel: this.errorModel
            });
            this.view.render();

            var $window = $(window);
            var $document = $(document);
            var $sidebarBody = $('.aui-sidebar-body');

            this.dialog = AJS.InlineDialog(this.sidebarItem.ui.link, 'project-shortcuts-group__add-dialog',
                function(content, trigger, showPopup) {
                    instance.sidebarItem.$el.addClass('aui-nav-selected');
                    instance.view.render();
                    instance.view.$el.appendTo(content);
                    instance.view.ui.url.focus();
                    $window.on('scroll.project-shortcuts', function windowScroll() {
                        instance.refresh();
                    });
                    $sidebarBody.on('scroll.project-shortcuts', function sidebarScroll() {
                        instance.hide();
                    });

                    $document.on("showLayer", instance.focusForm);
                    $window.on("resize", instance.refresh);

                    showPopup();
                    return false;
                }, {
                    gravity: 'w',
                    autoWidth: true,
                    initCallback: function initCallback() {
                        instance.trigger("dialog:open");
                        instance.analyticsSave = false;
                    },
                    hideCallback: function hideCallback() {
                        instance.sidebarItem.$el.removeClass('aui-nav-selected');
                        instance.sidebarItem.ui.link.blur();
                        $window.off('scroll.project-shortcuts');
                        $sidebarBody.off('scroll.project-shortcuts');
                        $document.off("showLayer", instance.focusForm);

                        instance.trigger("dialog:close", instance.analyticsSave);
                    },
                    persistent: true,
                    closeOnTriggerClick: true,
                    offsetY: function offsetY(popup, targetPosition) {
                        var halfTriggerHeight = targetPosition.target.height();
                        var halfPopupHeight = popup.height() / 2;
                        return halfPopupHeight - halfTriggerHeight - 10;
                    },
                    arrowOffsetY: function arrowOffsetY(popup, targetPosition) {
                        var halfTriggerHeight = targetPosition.target.height() / 2;
                        var halfPopupHeight = popup.height() / 2;
                        return -halfPopupHeight + 22 + halfTriggerHeight;
                    }
                }
            );

            this.listenTo(this.view, 'render', this.refresh);
            this.listenTo(this.view, 'cancel', this.hideAndRender);
            this.listenTo(this.model, 'save:success', function onModelSaved() {
                var createdModel = new JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcut(this.model.toJSON(), {
                    projectKey: this.projectKey
                });
                this.model.clear();
                this.collection.add(createdModel);

                this.analyticsSave = true;
                this.hide();
            });
            this.listenTo(this.sidebarItem, 'before:select', function(e) {
                e.preventDefault();
            });

            AJS.sidebar('.aui-sidebar').on('collapse-start', this.hide);
            $('.project-shortcuts-group').on('click', 'li', this.hide);
        },
        hide: function hide() {
            this.view.hideIconPicker();
            this.dialog.hide();
        },
        refresh: function refresh() {
            this.view.hideIconPicker();
            this.dialog.refresh();
        },
        hideAndRender: function hideAndRender() {
            this.hide();
        },
        focusForm: function focusForm() {
            this.view.ui.url.focus();
        }
    });

})(AJS.$);