require([
    'jira/skate',
    'wrm/require',
    'jquery',
    'jira/ajs/dark-features'
], function (
    skate,
    wrmRequire,
    jQuery,
    DarkFeatures
) {
    "use strict";

    var dclFired = false;
    var dclPromise = (function() {
        var deferred = new jQuery.Deferred();
        jQuery(function() {
            deferred.resolve();
            dclFired = true;
        });
        return deferred.promise();
    })();

    var resourcesLoadedPromise = (function() {
        if (DarkFeatures.isEnabled('com.atlassian.jira.projects.sidebar.DEFER_RESOURCES')
                && !DarkFeatures.isEnabled('com.atlassian.jira.projects.sidebar.DEFER_RESOURCES_KILLSWITCH')) {
            var projectType = JIRA.API.Projects.getCurrentProjectType();

            var contexts = ['wrc!jira.project.sidebar'];
            if (projectType) {
                contexts.push('wrc!jira.project.sidebar.' + projectType);
            }
            return wrmRequire(contexts);
        }
        return new jQuery.Deferred().resolve().promise();
    })();

    var sidebarInitialisedPromise = (function() {
        var deferred = new jQuery.Deferred();
        document.addEventListener('sidebar:initialised', function (evt) {
            JIRA.Projects.Sidebar.ExpansionManager(evt.detail);
            if (evt.target.classList.contains('projects-sidebar')) {
                deferred.resolve(evt);
            }
        });
        return deferred.promise();
    })();

    // make sure we never fire before DCL so the API is never initialised before that
    jQuery.when(sidebarInitialisedPromise, resourcesLoadedPromise, dclPromise).done(function (sidebarLoadedEvent) {
        var sidebar = sidebarLoadedEvent.target;
        var placeholder = sidebar.parentElement.querySelector('.sidebar-placeholder');
        if (placeholder) {
            sidebar.classList.add('fade-in');
            placeholder.addEventListener('animationend', function () {
                placeholder.parentNode.removeChild(placeholder);
            });
            placeholder.classList.add('fade-out')
        }
        sidebar.classList.remove('sidebar-pending');

        JIRA.trace('jira.projects.sidebar.init', {dclFired: dclFired});
        projectSidebarInit(sidebarLoadedEvent.detail);
    });

    skate('aui-sidebar', {
        type: skate.type.CLASSNAME,
        attached: function (el) {
            var sidebar = AJS.sidebar(el);

            // TODO: once we drop IE support this should be rewritten to new CustomEvent('sidebar:initialised', ...) - tracked in NEXT-697
            var evt = document.createEvent('CustomEvent');
            evt.initCustomEvent('sidebar:initialised', true, false, sidebar);
            el.dispatchEvent(evt);
        }
    });

    var projectSidebarInit = function (sidebar) {
        "use strict";

        // Keep in sync with the list in com.atlassian.jira.projects.util.PageIdHasher
        var prefixWhitelist = [
            // The constant "NONE" will represent id-less links that were clicked
            "NONE",
            "com.atlassian.jira.jira-projects-plugin:project-issue-search-link",
            "com.atlassian.jira.jira-projects-plugin:components-page",
            "com.atlassian.jira.jira-projects-plugin:reports-panel",
            "com.atlassian.jira.jira-projects-plugin:summary-panel",
            "com.atlassian.jira.jira-projects-plugin:summary-page",
            "com.atlassian.jira.jira-projects-plugin:components-page",
            "com.atlassian.jira.jira-projects-plugin:release-page",
            "com.atlassian.jira.jira-projects-plugin:release-sidebar-version-",
            "com.atlassian.jira.jira-projects-plugin:report-page",
            "com.pyxis.greenhopper.jira:global-sidebar-report",
            "com.pyxis.greenhopper.jira:global-sidebar-plan-scrum",
            "com.pyxis.greenhopper.jira:global-sidebar-work-scrum",
            "com.pyxis.greenhopper.jira:global-sidebar-work-kanban",
            "com.pyxis.greenhopper.jira:project-sidebar-plan-scrum",
            "com.pyxis.greenhopper.jira:project-sidebar-work-scrum",
            "com.pyxis.greenhopper.jira:project-sidebar-work-kanban",
            "com.pyxis.greenhopper.jira:project-invite-users-link",
            "com.pyxis.greenhopper.jira:sidebar-feedback-link",
            "com.atlassian.jira.jira-projects-issue-navigator:embedded-issue-navigator-link",
            "com.atlassian.jira.jira-projects-issue-navigator:sidebar-issue-navigator",
            "com.atlassian.jira.jira-projects-plugin:project-invite-users-link",
            "com.atlassian.jira.jira-projects-plugin:sidebar-feedback-link",
            "com.atlassian.jira.jira-one-click-invite-plugin:project-invite-users-link"
        ];

        function initSidebarBadges(sidebar) {
            var badges = jQuery('.aui-sidebar .aui-badge');
            badges.tooltip({gravity: 'w'});

            if (sidebar.isCollapsed()) {
                badges.tooltip('disable');
            }

            sidebar.on('collapse-end expand-end', function () {
                jQuery(".tipsy").remove();
                jQuery('.aui-sidebar .aui-badge').tooltip('toggleEnabled');
            });
        }

        /**
         * Schedules a reflow of the sidebar, so its height is recomputed periodically.
         *
         * We need this to bring back the bottom of the sidebar, which gets lost when
         * banners get displayed on the top of the page after it's loaded.
         */
        function scheduleSidebarReflow() {
            function reflow() {
                JIRA.API.Sidebar.getAUISidebar().reflow();
            }

            setTimeout(reflow, 200);
            setInterval(reflow, 5 * 60 * 1000);
        }

        function initDropdownCloser(sidebar) {
            sidebar.on('collapse-start', function () {
                var dropdown = sidebar.$el.find(".scope-filter-trigger");
                if (dropdown.hasClass("aui-dropdown2-active")) {
                    dropdown.trigger("aui-button-invoke");
                }
            });
        }

        function attachProjectTypesWarningDialog() {
            require("jira/project/types/warning/dialog").init({
                onProjectTypeChanged: function () {
                    // we want to take the user to the summary page, just in case the project type
                    // change happens from a page for which she will have no access to after the type has changed
                    var projectKey = JIRA.API.Projects.getCurrentProjectKey();
                    window.location.replace(AJS.contextPath() + "/projects/" + projectKey + "/summary");
                }
            });
            JIRA.trace("project.types.warning.messages.init");
        }


        JIRA.Projects.Sidebar.initAPI(new JIRA.Projects.Sidebar.Component({el: sidebar.$el[0]}));

        _(prefixWhitelist).each(JIRA.Projects.Sidebar.Analytics.Hash.addPrefix);
        JIRA.Projects.Sidebar.Analytics('.aui-sidebar');

        initDropdownCloser(sidebar);
        initSidebarBadges(sidebar);
        scheduleSidebarReflow();
        attachProjectTypesWarningDialog();

        JIRA.API.getSidebar().done(function (sidebar) {
            JIRA.Projects.Sidebar.LastVisited.Updater.start(sidebar);
        });
    };
});

