AJS.test.require("com.atlassian.jira.jira-projects-plugin:marionette-test", function() {
    "use strict";

    module("JIRA.Projects.Libs.Marionette.triggerPreventable", {
        setup: function() {
            this.controller = new JIRA.Projects.Libs.Marionette.Controller();
        },

        assertPreventableEventPropertiesPresent: function(event) {
            ok(typeof event.isPrevented === "boolean");
            ok(typeof event.emitter === "object");
            ok(typeof event.preventDefault === "function");
        }
    });

    test("Builds a new preventable event object if none is passed", function() {
        var event = this.controller.triggerPreventable("eventName");

        this.assertPreventableEventPropertiesPresent(event);
    });

    test("The preventable event object built by default is not prevented", function() {
        var event = this.controller.triggerPreventable("eventName");

        strictEqual(event.isPrevented, false);
    });

    test("The preventable event object built by default can be prevented", function() {
        var event = this.controller.triggerPreventable("eventName");

        event.preventDefault();

        strictEqual(event.isPrevented, true);
    });

    test("The preventable event object built by default has the emitter correctly set", function() {
        var event = this.controller.triggerPreventable("eventName");

        equal(event.emitter, this.controller);
    });

    test("Adds preventable event properties to given event if they are not present", function() {
        var myObject = { a: 42 };

        var event = this.controller.triggerPreventable("eventName", { data: myObject });

        equal(event.data, myObject);
        this.assertPreventableEventPropertiesPresent(event);
    });

    test("Respects preventable event properties present the given event object", function() {
        var initialEventObject = this.controller.triggerPreventable("eventName");
        initialEventObject.preventDefault();

        var event = this.controller.triggerPreventable("another-event", initialEventObject);

        equal(event.isPrevented, true);
        deepEqual(event, initialEventObject);
    });

    test("Triggers an event with the event object", function() {
        var spy = this.spy();
        this.controller.on("eventName", spy);

        var event = this.controller.triggerPreventable("eventName");

        sinon.assert.calledOnce(spy);
        sinon.assert.calledWith(spy, event);
    });

    test("Triggers a :prevented event if the original event is prevented", function() {
        var spy = this.spy();
        this.controller.on("eventName:prevented", spy);

        var event = this.controller.triggerPreventable("eventName");
        event.preventDefault();

        sinon.assert.calledWith(spy, event);
    });
});
