define("jira/projects/sidebar/lastvisited/updater", [
    "jquery"
], function(
    $
) {
    "use strict";

    function updateLastViewedItem(projectKey, selectedItemId, callback) {
        if (!projectKey) return;

        callback = callback || function () {
            JIRA.trace("last.visited.item.saved");
        };
        $.ajax({
            url: AJS.contextPath() + "/rest/projects/1.0/project/" + encodeURIComponent(projectKey) + "/lastVisited",
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify({
                id: selectedItemId
            })
        }).done(callback);
    }


    return {
        start: function (sidebar, callback) {
            var currentProjectKey = (JIRA.API && JIRA.API.Projects && JIRA.API.Projects.getCurrentProjectKey()) || null;
            var selectedNavItem = sidebar.getSelectedNavigationItem();
            if (selectedNavItem) {
                updateLastViewedItem(currentProjectKey, selectedNavItem.getId(), callback);
            }
            sidebar.on("before:navigate:prevented", function (event) {
                updateLastViewedItem(currentProjectKey, event.emitter.id, callback);
            });
            sidebar.on("before:select", function (event) {
                if (event.isInitial) {
                    updateLastViewedItem(currentProjectKey, event.emitter.id, callback);
                }
            });
        }
    };
});

AJS.namespace("JIRA.Projects.Sidebar.LastVisited.Updater", null, require("jira/projects/sidebar/lastvisited/updater"));
