(function () {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.FeatureDiscovery");

    function removeBadgesFor(navigationItems) {
        _.each(navigationItems, function(navigationItemId) {
            var navigationItem = JIRA.API.Sidebar.getItem(navigationItemId);
            if (navigationItem) {
                navigationItem.removeBadge();
            }
        });
    }

    JIRA.Projects.Sidebar.FeatureDiscovery = {
        /**
         * Updates the badges displayed next to the links on the sidebar.
         */
        updateBadges: function() {
            // a global board sidebar does not have a single project key to be used
            if (typeof JIRA.API.Projects.getCurrentProjectKey() === 'undefined') {
                return;
            }

            AJS.$.ajax({
                url: AJS.contextPath() + '/rest/projects/1.0/project/' + encodeURIComponent(JIRA.API.Projects.getCurrentProjectKey()) + '/badges',
                type: "PUT",
                contentType:"application/json"
            }).done(function(response) {
                removeBadgesFor(response.badgesToRemove || []);
            });
        }
    }
}());
