AJS.test.require(["com.atlassian.jira.jira-projects-plugin:feature-discovery-test"], function(){
    "use strict";

    module("JIRA.Projects.Sidebar.FeatureDiscovery", {

        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.server = sinon.fakeServer.create();
        },

        teardown: function() {
            this.server.restore();
            this.sandbox.restore();
        },

        mockCurrentProject: function(projectKey) {
            this.sandbox.stub(JIRA.API.Projects, "getCurrentProjectKey").returns(projectKey);
        },

        mockServerResponse: function(projectKey, badgesToRemove) {
            this.server.respondWith(
                "PUT",
                    AJS.contextPath() + '/rest/projects/1.0/project/' + projectKey + '/badges',
                [
                    200,
                    { "Content-Type": "application/json" },
                    JSON.stringify({ badgesToRemove: badgesToRemove})
                ]
            );
        },

        mockNavigationItemWithId: function(navigationItemId) {
            var navigationItem = { removeBadge: function() {} };
            this.mockSidebarApi();
            JIRA.API.Sidebar.getItem.withArgs(navigationItemId).returns(navigationItem);
            return navigationItem;
        },

        mockNonExistentNavigationItemWithId: function(navigationItemId) {
            this.mockSidebarApi();
            JIRA.API.Sidebar.getItem.withArgs(navigationItemId).returns(undefined);
        },

        mockSidebarApi: function() {
            AJS.namespace("JIRA.API.Sidebar");
            if (!JIRA.API.Sidebar.getItem) {
                JIRA.API.Sidebar.getItem = function () {}
            }

            this.sandbox.stub(JIRA.API.Sidebar, "getItem")
        }
    });

    test("Should remove the badges for the navigation items sent by the server in the response", function() {
        var projectKey = "KEY";
        this.mockCurrentProject(projectKey);

        var badgesToRemove = ["navigationItem"];
        this.mockServerResponse(projectKey, badgesToRemove);

        var navigationItem = this.mockNavigationItemWithId("navigationItem");
        var removeBadge = this.sandbox.spy(navigationItem, "removeBadge");

        JIRA.Projects.Sidebar.FeatureDiscovery.updateBadges();
        this.server.respond();

        sinon.assert.calledOnce(removeBadge);
    });

    test("Should not execute badges request if no project key is defined", function() {
        this.mockCurrentProject(undefined);

        this.sandbox.spy(AJS.$, "ajax");
        JIRA.Projects.Sidebar.FeatureDiscovery.updateBadges();

        sinon.assert.notCalled(AJS.$.ajax);
    });

    test("Should do nothing on the navigation items sent by the server if they don't exist", function() {
        var projectKey = "KEY";
        this.mockCurrentProject(projectKey);

        var badgesToRemove = ["navigationItem"];
        this.mockServerResponse(projectKey, badgesToRemove);

        var navigationItem = this.mockNonExistentNavigationItemWithId("navigationItem");

        JIRA.Projects.Sidebar.FeatureDiscovery.updateBadges();
        this.server.respond();

        ok(true, "Non existent navigation items have been handled properly, since no exceptions have occurred");
    });

});

