(function() {
    "use strict";

    var STORAGE_KEY = 'jira-sidebar-collapsed';

    AJS.namespace('JIRA.Projects.Sidebar');

    JIRA.Projects.Sidebar.initExpansionManager = function () {

        var isSidebarCollapsedByDefault = Boolean(WRM.data.claim('sidebar-collapsed-by-default'));

        /**
         * @param {AJS.sidebar} sidebar An AUI sidebar.
         * @param {Storage} [storage=window.localStorage] The object in which to
         *     persist `sidebar`'s expansion state.
         */
        JIRA.Projects.Sidebar.ExpansionManager = function(sidebar, storage) {
            storage || (storage = window.localStorage);

            restoreCollapsedState();
            sidebar.on("expand-start", controlCollapsedStateOnResize);
            sidebar.on('expand-end collapse-end', persistCollapsedState);

            function controlCollapsedStateOnResize(event) {
                // prevent auto-expansion if user collapsed the sidebar before
                if (event.isResponsive && storage[STORAGE_KEY] === 'true') {
                    event.preventDefault();
                }
            }

            function persistCollapsedState(event) {
                // remember the collapsed state only when it collapses on user's request
                // and viewport is not narrow at the moment
                if (!event.isResponsive && !sidebar.isViewportNarrow()) {
                    storage[STORAGE_KEY] = sidebar.isCollapsed().toString();
                }
            }

            function restoreCollapsedState() {
                if (sidebar.reflow() && sidebar.isViewportNarrow()) {
                    return;
                }

                if ((isSidebarCollapsedByDefault && storage[STORAGE_KEY] === undefined) || storage[STORAGE_KEY] === 'true') {
                    sidebar.collapse();
                } else {
                    sidebar.expand();
                }
            }
        };
    }

    JIRA.Projects.Sidebar.initExpansionManager();

})();