(function () {
    "use strict";

    AJS.namespace("JIRA.Projects.Sidebar.Component.NavigationSubgroup");

    JIRA.Projects.Sidebar.Component.NavigationSubgroup = JIRA.Projects.Sidebar.Component.NavigationGroup.extend({
        childEvents: {
            "before:select": function (item, itemEvent) {
                JIRA.Projects.Sidebar.Component.NavigationGroup.prototype.childEvents["before:select"].apply(this, arguments);
                if (!itemEvent.isPrevented) {
                    this.expand();
                }
            }
        },

        initialize: function() {
            // Inherit childEvents
            this.childEvents = _.extend({}, JIRA.Projects.Sidebar.Component.NavigationGroup.prototype.childEvents, this.childEvents);

            JIRA.Projects.Sidebar.Component.NavigationGroup.prototype.initialize.apply(this, arguments);
            this.id = this.$el.find(">a[data-link-id]").attr("data-link-id");
        },

        expand: function () {
            // Most of the expand/collapse logic is already handled by AJS.sidebar(). As we can't detect all the
            // expansion events, it is better to not provide events for this action at all.
            this.$el.attr('aria-expanded', 'true');
        },

        collapse: function () {
            // Most of the expand/collapse logic is already handled by AJS.sidebar(). As we can't detect all the
            // expansion events, it is better to not provide events for this action at all.
            this.$el.attr('aria-expanded', 'false');
        },

        isExpanded: function() {
            return this.$el.attr('aria-expanded') === 'true';
        },

        isSelected: function() {
            return this.$el.hasClass("aui-nav-selected");
        },

        getId: function() {
            return this.id;
        },

        getSelectedNavigationItem: function() {
            if (this.isSelected()) {
                return this;
            }
            var selectedItem = this.children.find(function(child) {
                return child.hasASelectedItem();
            });
            if (selectedItem) {
                return selectedItem.getSelectedNavigationItem();
            }
        },

        hasASelectedItem: function() {
            if (this.isSelected()) {
                return true;
            }
            return this.children.any(function(child) {
                return child.hasASelectedItem();
            });
        }
    });
}());