AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-component"],function(){module("JIRA.Projects.Sidebar.Component.NavigationItem",{markup:'<li><a class="aui-nav-item" data-link-id="my-navigation-item"></a></li>',markupWithBadge:'<li><a class="aui-nav-item" data-link-id="my-navigation-item"><span class="aui-badge">badge</span></a></li>',buildNavigationItem:function(){return new JIRA.Projects.Sidebar.Component.NavigationItem({el:this.markup})},buildSelectedNavigationItem:function(){var a=new JIRA.Projects.Sidebar.Component.NavigationItem({el:this.markup});a.select();return a},buildNavigationItemWithLink:function(a){var b=this.buildNavigationItem();var c=this.stub(b.$el,"find");c.withArgs("a").returns(a);return b},buildNavigationItemWithBadge:function(){return new JIRA.Projects.Sidebar.Component.NavigationItem({el:this.markupWithBadge})}});test("Extracts the link ID from the markup when constructed",function(){var a=this.buildNavigationItem();equal(a.id,"my-navigation-item")});test("When navigating on a item, it selects the item",function(){var a=this.buildNavigationItem();a.ui.link.attr("href","http://example.com");this.stub(require("jira/util/browser"),"reloadViaWindowLocation");a.navigate();ok(a.isSelected())});test("When navigating on a item, it navigates to the link url",function(){var a=this.buildNavigationItem();a.ui.link.attr("href","http://example.com");var b=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");a.navigate();sinon.assert.calledOnce(b);sinon.assert.calledWith(b,"http://example.com")});test("When navigating on a item, it triggers the event 'before:select', 'select' and 'before:navigate', in that order",function(){var b=this.spy();var a=this.spy();var c=this.spy();var d=this.buildNavigationItem();d.on("before:navigate",c);d.on("before:select",b);d.on("select",a);this.stub(require("jira/util/browser"),"reloadViaWindowLocation");d.navigate();sinon.assert.calledOnce(b);sinon.assert.calledOnce(a);sinon.assert.calledOnce(c);sinon.assert.callOrder(b,a,c)});test("When navigating on a item, it does not trigger the event 'select' if 'before:select' has been prevented",function(){var a=this.spy();var b=this.buildNavigationItem();b.on("before:select",function(c){c.preventDefault()});b.on("select",a);b.navigate();sinon.assert.notCalled(a)});test("When navigating on a item, it does not trigger the event 'before:navigate' if 'before:select' has been prevented",function(){var a=this.spy();var b=this.buildNavigationItem();b.on("before:select",function(c){c.preventDefault()});b.on("before:navigate",a);b.navigate();sinon.assert.notCalled(a)});test("When navigating on a item, it does not navigates if the 'before:select' event is prevented",function(){var a=this.buildNavigationItem();a.on("before:select",function(c){c.preventDefault()});a.ui.link.attr("href","http://example.com");var b=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");a.ui.link.click();sinon.assert.notCalled(b)});test("When navigating on a item, it does not navigates if the 'before:navigate' event is prevented",function(){var a=this.buildNavigationItem();a.on("before:navigate",function(c){c.preventDefault()});a.ui.link.attr("href","http://example.com");var b=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");a.navigate();sinon.assert.notCalled(b)});test("Selects the element",function(){var a=this.buildNavigationItem();a.select();ok(a.isSelected())});test("When selecting the item, it triggers the events 'before:select' and 'select', in that order",function(){var b=this.spy();var a=this.spy();var c=this.buildNavigationItem();c.on("before:select",b);c.on("select",a);c.select();sinon.assert.calledOnce(b);sinon.assert.calledOnce(a);sinon.assert.callOrder(b,a)});test("When selecting the item, it does not trigger the event 'select' if 'before:select' has been prevented",function(){var a=this.spy();var b=this.buildNavigationItem();b.on("before:select",function(c){c.preventDefault()});b.on("select",a);b.select();ok(!a.called)});test("Deselects the element",function(){var a=this.buildSelectedNavigationItem();a.deselect();ok(!a.isSelected())});test("When deselecting the item, it triggers the event 'before:deselect' and 'deselect', in that order",function(){var c=this.spy();var a=this.spy();var b=this.buildSelectedNavigationItem();b.on("before:deselect",c);b.on("deselect",a);b.deselect();sinon.assert.calledOnce(c);sinon.assert.calledOnce(a);sinon.assert.callOrder(c,a)});test("When deselecting the item, it does not trigger the event 'deselect' if 'before:deselect' has been prevented",function(){var a=this.spy();var b=this.buildSelectedNavigationItem();b.on("before:deselect",function(c){c.preventDefault()});b.on("deselect",a);b.deselect();sinon.assert.notCalled(a)});test("When deselecting the item, it does not trigger any event if the element was not initially selected",function(){var a=this.spy();var b=this.spy();var c=this.buildNavigationItem();c.on("before:deselect",b);c.on("deselect",a);c.deselect();sinon.assert.notCalled(a);sinon.assert.notCalled(b)});test("When deselecting the navigation item, it removes the focus from its link",function(){var a=AJS.$("<a>");this.spy(a,"blur");var b=this.buildNavigationItemWithLink(a);b.select();b.deselect();sinon.assert.calledOnce(a.blur)});test("When clicking the item's link, it triggers the events 'before:select', 'select' and 'before:navigate', in that order",function(){var b=this.spy();var a=this.spy();var c=this.spy();var d=this.buildNavigationItem();d.on("before:select",b);d.on("select",a);d.on("before:navigate",c);d.ui.link.click();sinon.assert.calledOnce(b);sinon.assert.calledOnce(a);sinon.assert.calledOnce(c);sinon.assert.callOrder(b,a,c)});test("When clicking the item's link, it navigates to the link url",function(){var a=this.buildNavigationItem();a.ui.link.attr("href","http://example.com");var b=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");a.ui.link.click();sinon.assert.calledOnce(b);sinon.assert.calledWith(b,"http://example.com")});test("When clicking the item's link with ctrl/cmd key, it uses standard browser's mechanism to navigate to the link url",function(){var d=this.buildNavigationItem();d.ui.link.attr("href","http://example.com");var a=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");var c=sinon.stub();d.on("before:navigate",c);d.on("before:select",c);d.on("select",c);var b=jQuery.Event("click",{metaKey:true});d.ui.link.trigger(b);sinon.assert.notCalled(a);sinon.assert.notCalled(c)});test("When clicking the item's link with target=_blank attribute, it uses standard browser's mechanism to navigate to the link url",function(){var c=this.buildNavigationItem();c.ui.link.attr("href","http://example.com");c.ui.link.attr("target","_blank");var a=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");var b=sinon.stub();c.on("before:navigate",b);c.on("before:select",b);c.on("select",b);c.ui.link.trigger("click");sinon.assert.notCalled(a);sinon.assert.notCalled(b)});test("When clicking the item's link, it does not trigger the event 'select' if 'before:select' has been prevented",function(){var a=this.spy();var b=this.buildNavigationItem();b.on("before:select",function(c){c.preventDefault()});b.on("select",a);b.ui.link.click();sinon.assert.notCalled(a)});test("When clicking the item's link, it does not navigates if the 'before:select' event is prevented",function(){var a=this.buildNavigationItem();a.on("before:select",function(c){c.preventDefault()});a.ui.link.attr("href","http://example.com");var b=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");a.ui.link.click();sinon.assert.notCalled(b)});test("When clicking the item's link, it does not navigates if the 'before:navigate' event is prevented",function(){var a=this.buildNavigationItem();a.on("before:navigate",function(c){c.preventDefault()});a.ui.link.attr("href","http://example.com");var b=this.stub(require("jira/util/browser"),"reloadViaWindowLocation");a.ui.link.click();sinon.assert.notCalled(b)});test("When removing the badge, the right DOM element is removed",function(){var a=this.buildNavigationItemWithBadge();a.removeBadge();equal(a.$el.find("a .aui-badge").length,0)});test("Returns the expected ID when the getId method is called",function(){var a=this.buildNavigationItem();equal(a.getId(),"my-navigation-item")});test("Returns itself if it is selected and the getSelectedNavigationItem method is called",function(){var b=this.buildSelectedNavigationItem();var a=b.getSelectedNavigationItem();ok(a===b)});test("Does not return itself if it isn't selected and the getSelectedNavigationItem method is called",function(){var b=this.buildNavigationItem();var a=b.getSelectedNavigationItem();ok(!(a===b))});test("Reports that it has a selected item when it is selected",function(){var a=this.buildSelectedNavigationItem();ok(a.hasASelectedItem())});test("Reports that it does not have a selected item when not selected",function(){var a=this.buildNavigationItem();ok(!a.hasASelectedItem())});test("When it is destroyed, events are unbound",function(){var a=this.buildNavigationItem();var b=sinon.stub();a.on("test-event",b);a.destroy();a.trigger("test-event");sinon.assert.notCalled(b)})});