AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-component"],function(){module("JIRA.Projects.Sidebar.Component.NavigationGroup",{markup:['<div data-id="my-navigation-group">',"   <ul>",'       <li><a class="aui-nav-item" data-link-id="my-navigation-item-1">Link #1</a></li>','       <li><a class="aui-nav-item"></a>Link without id</li>','       <li><a class="aui-nav-item" data-link-id="my-navigation-item-3">Link #3</a></li>',"       <li>",'           <a class="aui-nav-item" data-link-id="my-navigation-item-4">Subgroup</a>',"           <ul>",'               <li><a class="aui-nav-item" data-link-id="my-navigation-subitem-1">Link #1</a></li>',"           </ul>","       </li>","   </ul>","</div>"].join(""),buildNavigationGroup:function(){return new JIRA.Projects.Sidebar.Component.NavigationGroup({el:this.markup})},buildNavigationGroupWithDuplicatedIDs:function(){return new JIRA.Projects.Sidebar.Component.NavigationGroup({el:this.markup.replace("my-navigation-item-3","my-navigation-item-1")})},triggerEventWithObject:function(c,b){var a={isPrevented:false,emitter:c,preventDefault:function(){this.isPrevented=true}};c.trigger(b,a);return a},assertEventRetriggered:function(e,d,c){var b=this.spy();e.on(c,b);var a=this.triggerEventWithObject(d,c);sinon.assert.calledOnce(b);sinon.assert.calledWith(b,a)},assertEventPreventedAndRetriggered:function(f,e,d){var c=function(g){g.preventDefault()};e.on(d,c);var b=this.spy();f.on(d,b);var a=this.triggerEventWithObject(e,d);sinon.assert.calledOnce(b);sinon.assert.calledWith(b,a);ok(a.isPrevented);e.off(d,c)}});test("When constructed, it extracts the link ID from the markup",function(){var a=this.buildNavigationGroup();equal(a.id,"my-navigation-group")});test("When constructed, it extracts the NavigationItems and NavigationSubgroups from the markup",function(){var a=this.buildNavigationGroup();ok(a.getItemAt(0) instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #0 is a NavigationItem");ok(a.getItemAt(1) instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #1 is a NavigationItem");ok(a.getItemAt(2) instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #2 is a NavigationItem");ok(a.getItemAt(3) instanceof JIRA.Projects.Sidebar.Component.NavigationSubgroup,"Item #3 is a NavigationSubgroup")});test("When constructed, it lots a warning if the markup has duplicated IDs for groups",function(){var a=this.stub(AJS,"warn");this.buildNavigationGroupWithDuplicatedIDs();sinon.assert.calledOnce(a);sinon.assert.calledWith(a,"Duplicated IDs detected. There are more than one NavigationItem with id data-link-id='my-navigation-item-1'")});test("It deselects all the items",function(){var a=this.stub(JIRA.Projects.Sidebar.Component.NavigationItem.prototype,"deselect");var b=this.buildNavigationGroup();b.deselect();sinon.assert.calledOn(a,b.getItemAt(0));sinon.assert.calledOn(a,b.getItemAt(1));sinon.assert.calledOn(a,b.getItemAt(2))});test("When deselecting all the items, it propagates the call to the subgroups",function(){var a=this.stub(JIRA.Projects.Sidebar.Component.NavigationSubgroup.prototype,"deselect");var b=this.buildNavigationGroup();b.deselect();sinon.assert.calledOn(a,b.getItemAt(3))});test("It fetches the items by the id",function(){var a=this.buildNavigationGroup();ok(a.getItem("my-navigation-item-1") instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #1 is a NavigationItem");ok(a.getItem("my-navigation-item-3") instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #2 is a NavigationItem");ok(a.getItem("my-navigation-item-4") instanceof JIRA.Projects.Sidebar.Component.NavigationGroup,"Item #3 is a NavigationGroup")});test("It fetches the items by the index",function(){var a=this.buildNavigationGroup();ok(a.getItemAt(0) instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #0 is a NavigationItem");ok(a.getItemAt(1) instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #1 is a NavigationItem");ok(a.getItemAt(2) instanceof JIRA.Projects.Sidebar.Component.NavigationItem,"Item #2 is a NavigationItem");ok(a.getItemAt(3) instanceof JIRA.Projects.Sidebar.Component.NavigationGroup,"Item #3 is a NavigationGroup")});test("When a children triggers an event, the NavigationGroup re-triggers it with the same EventObject",function(){var c=this.buildNavigationGroup();var a=c.getItemAt(0);this.assertEventRetriggered(c,a,"before:select");this.assertEventRetriggered(c,a,"select");this.assertEventRetriggered(c,a,"before:deselect");this.assertEventRetriggered(c,a,"deselect");this.assertEventRetriggered(c,a,"before:navigate");var b=c.getItemAt(3);this.assertEventRetriggered(c,b,"before:select");this.assertEventRetriggered(c,b,"select");this.assertEventRetriggered(c,b,"before:deselect");this.assertEventRetriggered(c,b,"deselect");this.assertEventRetriggered(c,b,"before:navigate")});test("When a children triggers an event, the NavigationGroup re-triggers it with the same EventObject, even if the original event was prevented",function(){var c=this.buildNavigationGroup();var a=c.getItemAt(0);this.assertEventPreventedAndRetriggered(c,a,"before:select");this.assertEventPreventedAndRetriggered(c,a,"before:deselect");this.assertEventPreventedAndRetriggered(c,a,"before:navigate");var b=c.getItemAt(3);this.assertEventPreventedAndRetriggered(c,b,"before:select");this.assertEventPreventedAndRetriggered(c,b,"before:deselect");this.assertEventPreventedAndRetriggered(c,b,"before:navigate")});test("When a children triggers the before:select event, it deselects all the other items in the group",function(){var a=this.stub(JIRA.Projects.Sidebar.Component.NavigationItem.prototype,"deselect");var b=this.stub(JIRA.Projects.Sidebar.Component.NavigationSubgroup.prototype,"deselect");var c=this.buildNavigationGroup();this.triggerEventWithObject(c.getItemAt(0),"before:select");sinon.assert.calledOn(a,c.getItemAt(0));sinon.assert.calledOn(a,c.getItemAt(1));sinon.assert.calledOn(a,c.getItemAt(2));sinon.assert.calledOn(b,c.getItemAt(3))});test("When a children is selected, the item is not selected if the previously selected child prevents the 'before:deselect' event",function(){var a=this.buildNavigationGroup();a.getItemAt(0).select();a.getItemAt(0).on("before:deselect",function(b){b.preventDefault()});a.getItemAt(1).select();ok(a.getItemAt(0).isSelected(),"Item #0 is still selected");ok(!a.getItemAt(1).isSelected(),"Item #1 is not selected")});test("When deselecting all the items, it returns true if all the views were deselected",function(){var b=this.buildNavigationGroup();var a=b.deselect();strictEqual(a,true)});test("When deselecting all the items, it returns false if any 'before:deselect' event is cancelled",function(){var b=this.buildNavigationGroup();b.getItemAt(0).select();b.getItemAt(0).on("before:deselect",function(c){c.preventDefault()});var a=b.deselect();strictEqual(a,false)});test("When receiving a before:navigate:prevented event, we retrigger it",function(){var d=this.buildNavigationGroup();var c=this.spy(d,"trigger");var b=d.getItemAt(0);var a={emitter:b};b.trigger("before:navigate:prevented",a);sinon.assert.calledWith(c,"before:navigate:prevented",a)});test("Gets the correct navigation item if there is one selected",function(){var b=this.buildNavigationGroup();var a=b.getItemAt(2);a.select();ok(b.getSelectedNavigationItem()===a)});test("Does not get the selected navigation item if one does not exist",function(){var a=this.buildNavigationGroup();ok(a.getSelectedNavigationItem()===undefined)});test("Reports that it has a selected navigation item if there is one selected",function(){var b=this.buildNavigationGroup();var a=b.getItemAt(2);a.select();ok(b.hasASelectedItem())});test("Reports that it does not have a selected navigation item if none is selected",function(){var a=this.buildNavigationGroup();ok(!a.hasASelectedItem())});test("When it is destroyed, events are unbound",function(){var a=this.buildNavigationGroup();var b=sinon.stub();a.on("test-event",b);a.destroy();a.trigger("test-event");sinon.assert.notCalled(b)})});