AJS.test.require("com.atlassian.jira.jira-projects-plugin:sidebar-analytics", function() {
    "use strict";
    var $ = AJS.$;

    function getAJSTriggerCallForClickEvent() {
        for (var i = 0; i < AJS.trigger.callCount; i++) {
            var eventArgs = AJS.trigger.getCall(i).args[1];
            if (eventArgs && eventArgs.name === "jira.project.centric.navigation.sidebar.click.link") {
                return AJS.trigger.getCall(i);
            }
        }
        return null;
    }

    function getAJSTriggerCallForLoadEvent() {
        for (var i = 0; i < AJS.trigger.callCount; i++) {
            var eventArgs = AJS.trigger.getCall(i).args[1];
            if (eventArgs && eventArgs.name.indexOf("jira.project.centric.navigation.sidebar.load") > -1) {
                return AJS.trigger.getCall(i);
            }
        }
        return null;
    }

    function assertClickEventTriggeredIncludesSource() {
        var clickTriggerCall = getAJSTriggerCallForClickEvent();
        // this isn't set so by default it's "unknown"
        equal(clickTriggerCall.args[1].data.sidebarSourcePage, "unknown");
    }

    function assertClickEventTriggeredWithHashedId(id) {
        ok(
            JIRA.Projects.Sidebar.Analytics.Hash.prefixedHash.calledWith(id),
            "id hashed before transmission"
        );

        //Get the call for triggering the click event
        var clickTriggerCall = getAJSTriggerCallForClickEvent();

        ok(clickTriggerCall, "Triggered event for click");
        equal(clickTriggerCall.args[0], "analyticsEvent");
        equal(clickTriggerCall.args[1].name, "jira.project.centric.navigation.sidebar.click.link");
        equal(clickTriggerCall.args[1].data.id, "hash-ed");
        equal(clickTriggerCall.args[1].data.prefix, "hash-");
    }

    function assertClickEventTriggeredWithSpecifiedContents(contents) {
        startAnalyticsWithProjectSidebarAndClick();
        var clickTriggerCall = getAJSTriggerCallForClickEvent();
        ok(clickTriggerCall, "Triggered event for click");
        equal(clickTriggerCall.args[0], "analyticsEvent");
        equal(clickTriggerCall.args[1].name, "jira.project.centric.navigation.sidebar.click.link");
        equal(clickTriggerCall.args[1].data.id, "hash-ed");
        equal(clickTriggerCall.args[1].data.prefix, "hash-");
        equal(clickTriggerCall.args[1].data.sidebarSourcePage, contents);
    }

    function addMetaTagToQunitFixture(name, content) {
        $("#qunit-fixture").append("<meta name='" + name + "' content='" + content + "'>");
    }

    function addMetaForProjectConfigSection() {
        addMetaTagToQunitFixture("admin.active.section", "atl.jira.proj.config");
    }

    function addMetaForProjectConfigTab(contents) {
        addMetaTagToQunitFixture("admin.active.tab", contents);
    }

    function assertLoadEventForGlobalSidebar() {
        var loadTriggerCall = getAJSTriggerCallForLoadEvent();
        equal(loadTriggerCall.args[0], "analyticsEvent");
        equal(loadTriggerCall.args[1].name, "jira.project.centric.navigation.sidebar.load.global");
    }

    function assertLoadEventForProjectSidebar() {
        var loadTriggerCall = getAJSTriggerCallForLoadEvent();
        equal(loadTriggerCall.args[0], "analyticsEvent");
        equal(loadTriggerCall.args[1].name, "jira.project.centric.navigation.sidebar.load.project");
    }

    function startAnalyticsWithGlobalSidebar() {
        if (JIRA.API.Sidebar) {
            JIRA.API.Sidebar.isProjectSidebar.returns(false);
        }
        var $sidebar = $(
            '<div class="aui-sidebar" aria-expanded="true">' +
            '    <div class="aui-sidebar-wrapper">' +
            '        <div class="aui-sidebar-body">' +
            '            <header class="aui-page-header"></header>' +
            '            <!-- .aui-page-header -->' +
            '            <nav class="aui-navgroup aui-navgroup-vertical">' +
            '                <div class="aui-navgroup-inner">' +
            '                    <div class="aui-sidebar-group">' +
            '                        <div class="aui-nav-heading">Links in Selector</div>' +
            '                        <div class="aui-nav">' +
            '                            <a data-link-id="selector" href="#" aria-owns="selector-links"' +
            '                            aria-haspopup="true"' +
            '                            class="aui-button aui-dropdown2-trigger aui-style-default">Choose a link...</a>' +
            '                        </div>' +
            '                        <div class="aui-dropdown2 aui-style-default">' +
            '                            <ul class="aui-list-truncate">' +
            '                                <li><a data-link-id="selectee-1" href="http://example.com/">Link 2</a></li>' +
            '                            </ul>' +
            '                        </div>' +
            '                    </div>' +
            '                    <div class="aui-sidebar-group aui-sidebar-group-tier-one">' +
            '                        <div class="aui-nav-heading">Navigation</div>' +
            '                        <ul class="aui-nav">' +
            '                            <li class="aui-nav-selected">' +
            '                                <a data-link-id="parent" class="aui-nav-item" href="/jira/projects/KEY">' +
            '                                    <span class="aui-nav-item-label">Top-level</span>' +
            '                                </a>' +
            '                                <ul class="aui-nav">' +
            '                                    <li>' +
            '                                        <a data-link-id="child" href="#">' +
            '                                            <span class="aui-nav-item-label">Child link</span>' +
            '                                        </a>' +
            '                                    </li>' +
            '                                </ul>' +
            '                            </li>' +
            '                        </ul>' +
            '                    </div>' +
            '                </div>' +
            '            </nav>' +
            '        </div>' +
            '        <div class="aui-sidebar-footer">' +
            '            <a href="/jira/plugins/servlet/project-config/IN" class="aui-button aui-button-subtle aui-sidebar-settings-button" data-tooltip="Settings">' +
            '                <span class="aui-icon aui-icon-small aui-iconfont-configure"></span>' +
            '                <span class="aui-button-label">Settings</span></a>' +
            '            <a class="aui-button aui-button-subtle aui-sidebar-toggle" href="#"><span class="aui-icon aui-icon-small"></span></a>' +
            '        </div>' +
            '    </div>' +
            '</div>'
        );
        JIRA.Projects.Sidebar.Analytics($sidebar);
        return $sidebar;
    }

    function startAnalyticsWithProjectSidebar() {
        if (JIRA.API.Sidebar) {
            JIRA.API.Sidebar.isProjectSidebar.returns(true);
        }
        var $sidebar = $(
            '<div class="aui-sidebar" aria-expanded="true">' +
            '    <div class="aui-sidebar-wrapper">' +
            '        <div class="aui-sidebar-body">' +
            '            <header class="aui-page-header">' +
            '               <div class="aui-page-header-inner">' +
            '                   <div class="aui-page-header-image">' +
            '                       <a href="#">' +
            '                           <span class="aui-avatar aui-avatar-large aui-avatar-project">' +
            '                               <span class="aui-avatar-inner"><img src="#"></span>' +
            '                           </span>' +
            '                       </a>' +
            '                   </div>' +
            '                   <div class="aui-page-header-main">' +
            '                       <h1><a href="#">Versions</a></h1>' +
            '                   </div>' +
            '               </div>' +
            '            </header>' +
            '            <nav class="aui-navgroup aui-navgroup-vertical">' +
            '                <div class="aui-navgroup-inner">' +
            '                    <div class="aui-sidebar-group">' +
            '                        <div class="aui-nav-heading">Links in Selector</div>' +
            '                        <div class="aui-nav">' +
            '                            <a data-link-id="selector" href="#" aria-owns="selector-links"' +
            '                            aria-haspopup="true"' +
            '                            class="aui-button aui-dropdown2-trigger aui-style-default">Choose a link...</a>' +
            '                        </div>' +
            '                    </div>' +
            '                </div>' +
            '            </nav>' +
            '        </div>' +
            '    </div>' +
            '</div>'
        );
        JIRA.Projects.Sidebar.Analytics($sidebar);
        return $sidebar;
    }

    function startAnalyticsWithProjectSidebarAndClick() {
        var $sidebar = startAnalyticsWithProjectSidebar();
        $sidebar.find('[data-link-id=selector]').click();
    }

    module('JIRA.Projects.Sidebar.Analytics', {
        setup: function() {
            sinon.stub(AJS, 'trigger');
            sinon.stub(AJS, 'error');
            sinon.stub(JIRA.Projects.Sidebar.Analytics.Hash, 'prefixedHash').returns({
                prefix: 'hash-',
                hash: 'hash-ed'
            });

            AJS.namespace('JIRA.API.Sidebar');
            JIRA.API.Sidebar.isProjectSidebar = sinon.stub();
        },
        teardown: function() {
            AJS.trigger.restore();
            AJS.error.restore();
            JIRA.Projects.Sidebar.Analytics.Hash.prefixedHash.restore();
        }
    });


    test('Clicks look up data from meta', function() {
        var sidebarMeta = AJS.Meta.get("sidebar-source-page");
        try {
            AJS.Meta.set("sidebar-source-page", "rapid-board");
            var $sidebar = startAnalyticsWithGlobalSidebar();

            $sidebar.find('[data-link-id=parent]').click();

            var clickTriggerCall = getAJSTriggerCallForClickEvent();
            equal(clickTriggerCall.args[1].data.sidebarSourcePage, "rapid-board");
        }
        finally {
            AJS.Meta.set("sidebar-source-page", sidebarMeta);
        }
    });

    test('Sets the source page analytics key if admin.active.section and admin.active.tab are set to valid values', function() {
        addMetaForProjectConfigSection();
        addMetaForProjectConfigTab("view_project_summary");
        assertClickEventTriggeredWithSpecifiedContents("proj.config.view_project_summary");
    });

    test('Sets the source page analytics key if admin.active.section is valid and admin.active.tab is invalid', function() {
        addMetaForProjectConfigSection();
        addMetaForProjectConfigTab("this_is_an_invalid_value");
        assertClickEventTriggeredWithSpecifiedContents("proj.config");
    });

    test('Sets the source page analytics key to unknown if sidebar-source-page is set to an invalid value', function() {
        addMetaTagToQunitFixture("sidebar-source-page", "this_is_an_invalid_value");
        assertClickEventTriggeredWithSpecifiedContents("unknown");
    });

    test('Registers analytics triggers on top-level links', function() {
        var $sidebar = startAnalyticsWithGlobalSidebar();

        $sidebar.find('[data-link-id=parent]').click();

        assertClickEventTriggeredWithHashedId('parent');
        assertClickEventTriggeredIncludesSource('parent');
    });

    test('Registers analytics triggers on child links', function() {
        var $sidebar = startAnalyticsWithGlobalSidebar();

        $sidebar.find('[data-link-id=child]').click();

        assertClickEventTriggeredWithHashedId('child');
        assertClickEventTriggeredIncludesSource('parent');
    });

    test('Registers analytics triggers on dropdown triggers', function() {
        var $sidebar = startAnalyticsWithGlobalSidebar();

        $sidebar.find('[data-link-id=selector]').click();

        assertClickEventTriggeredWithHashedId('selector');
        assertClickEventTriggeredIncludesSource('parent');
    });

    test('Registers analytics triggers on dropdown children', function() {
        var $sidebar = startAnalyticsWithGlobalSidebar();

        $sidebar.find('[data-link-id=selectee-1]').click();

        assertClickEventTriggeredWithHashedId('selectee-1');
        assertClickEventTriggeredIncludesSource('parent');
    });

    test('Registers analytics triggers on link without an ID', function() {
        var $sidebar = startAnalyticsWithGlobalSidebar();

        $sidebar.find('.aui-sidebar-settings-button').click();

        assertClickEventTriggeredWithHashedId('NONE');
        assertClickEventTriggeredIncludesSource('parent');
    });

    test('Does not register click handlers on non-links', function() {
        var $sidebar = startAnalyticsWithGlobalSidebar();

        $sidebar.find('.aui-navgroup-inner').click();

        ok(!getAJSTriggerCallForClickEvent());
    });

    test('Triggers an event when the global sidebar is loaded', function() {
        startAnalyticsWithGlobalSidebar();

        assertLoadEventForGlobalSidebar();
    });

    test('Triggers an event when the project sidebar is loaded', function() {
        startAnalyticsWithProjectSidebar();

        assertLoadEventForProjectSidebar();
    });

    test('it should not start if the sidebar api is not available', function() {
        JIRA.API.Sidebar = null;

        // raises = alias for 'throws'. YUI thinks 'throws' is a reserved identifier
        raises(startAnalyticsWithGlobalSidebar);
        raises(startAnalyticsWithProjectSidebar);
        ok(!getAJSTriggerCallForLoadEvent());

    });

});
