define('jira/api/projects', ['jira/projects/data/WRM'], function (WRM) {
    'use strict';

    var projectKey = WRM.data.claim('project-key'),
        projectId = WRM.data.claim('project-id'),
        projectName = WRM.data.claim('project-name'),
        projectType = WRM.data.claim('project-type');

    return {
        getCurrentProjectId: function () {
            return projectId;
        },
        getCurrentProjectKey: function () {
            return projectKey;
        },
        getCurrentProjectName: function () {
            return projectName;
        },
        getCurrentProjectType: function() {
            return projectType;
        }
    };
});

AJS.namespace('JIRA.API.Projects', null, require('jira/api/projects'));