AJS.test.require(['com.atlassian.jira.jira-projects-plugin:projects-api'], function() {
    module('Projects Api', {
        setup: function() {
            this.WRM = {
                data: {
                    claim: sinon.stub()
                }
            };
            this.mock = AJS.test.mockableModuleContext();
            this.mock.mock('jira/projects/data/WRM', this.WRM);
        }
    });

    test('it should return the current project id', function() {

        var projectId = 101;
        this.WRM.data.claim.withArgs('project-id').returns(projectId);
        var api = this.mock.require('jira/api/projects');

        var result = api.getCurrentProjectId();

        equal(result, projectId);
    });

    test('it should return the current project key', function() {
        var projectKey = 'FOO';
        this.WRM.data.claim.withArgs('project-key').returns(projectKey);
        var api = this.mock.require('jira/api/projects');

        var result = api.getCurrentProjectKey();

        equal(result, projectKey);
    });

    test('it should return the current project name', function() {
        var projectName = 'My super cool project';
        this.WRM.data.claim.withArgs('project-name').returns(projectName);
        var api = this.mock.require('jira/api/projects');

        var result = api.getCurrentProjectName();

        equal(result, projectName);
    });

    test('it should return the current project type', function() {
        var projectType = 'business';
        this.WRM.data.claim.withArgs('project-type').returns(projectType);
        var api = this.mock.require('jira/api/projects');

        var result = api.getCurrentProjectType();

        equal(result, projectType);
    });


});