define("jira/projects/summary/redirecttoissuenav", [
    "jquery",
    "underscore",
    "jira/projects/util/browser"
], function(
    $,
    _,
    Browser
) {
    "use strict";

    function sidebarIssueNavUrlForProjectKey(projectKey) {
        return AJS.contextPath() + "/projects/" + encodeURIComponent(projectKey) + "/issues";
    }

    function redirectToSidebarIssueNav() {
        var currentProjectKey = JIRA.API && JIRA.API.Projects && JIRA.API.Projects.getCurrentProjectKey();
        if (currentProjectKey) {
            Browser.locationAssign(sidebarIssueNavUrlForProjectKey(currentProjectKey));
        }
    }

    return {
        start: function(selector) {
            $(selector).on("QuickCreateIssue.sessionComplete", _.bind(redirectToSidebarIssueNav, this));
        }
    };
});
