AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-initial-redirect-to-issuenav", function() {
    "use strict";

    require([
        "jquery",
        "underscore",
        "jira/projects/util/browser",
        "jira/projects/summary/redirecttoissuenav",
    ], function (
        $,
        _,
        Browser,
        RedirectToIssueNav
    ) {
        module("jira/projects/summary/redirecttoissuenav", {
            setup: function () {
                this.sandbox = sinon.sandbox.create();
                this.el = $("<div></div>");

                this.mockProjectKey();
            },

            tearDown: function () {
                this.sandbox.restore();
            },

            mockProjectKey: function() {
                sinon.stub(JIRA.API.Projects, "getCurrentProjectKey", function() {
                    return "KEY";
                });
            }
        });

        test("When a 'sessionComplete' event is triggered from the quick create issue dialog, it redirects to the sidebar issue nav", function () {
            var redirect = sinon.stub(Browser, "locationAssign");
            RedirectToIssueNav.start(this.el);

            $(this.el).trigger("QuickCreateIssue.sessionComplete");

            sinon.assert.calledOnce(redirect);
        });
    });
});
