(function() {
    "use strict";

    AJS.namespace("JIRA.Projects.Summary.Subnavigator");
    JIRA.Projects.Summary.Subnavigator.create = function(triggerPlaceholder, contentPlaceholder, titlePlaceholder) {
        return new JIRA.Projects.Subnavigator({
            id: "summary-options",
            triggerPlaceholder: triggerPlaceholder,
            contentPlaceholder: contentPlaceholder,
            titlePlaceholder: titlePlaceholder,
            itemGroups: [{
                id: "activity",
                label: AJS.I18n.getText("project.page.summary.subnavigator.item.activity.label")
            }, {
                id: "statistics",
                label: AJS.I18n.getText("project.page.summary.subnavigator.item.statistics.label")
            }],
            selectedItem: WRM.data.claim("mode"),
            hideSelectedItem: false,
            changeViewText: AJS.I18n.getText("project.page.summary.subnavigator.trigger")
        });
    };
}());
