AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-go-to-statistics-link-resources-test", function() {
    "use strict";

    require([
        "jquery"
    ], function(
        $
    ) {
        module("jira/projects/page/summary/navigation/gotostatistics", {
            setup: function() {
                this.router = JIRA.Projects.Summary.Router.create();
                this.statisticsLink = require("jira/projects/page/summary/navigation/gotostatistics");
                this.linkElement = $("<a></a>");

                this.statisticsLink.start(this.linkElement, this.router);
            }
        });

        test("When the link is clicked, it navigates to the statistics page", function() {
            this.spy(this.router, "goToStatistics");

            this.linkElement.click();

            sinon.assert.calledOnce(this.router.goToStatistics);
        });

        test("When the link is clicked, it triggers a 'statisticsLinkClicked' event", function() {
            this.spy(this.statisticsLink, "trigger");

            this.linkElement.click();

            sinon.assert.calledOnce(this.statisticsLink.trigger);
            sinon.assert.calledWith(this.statisticsLink.trigger, "statisticsLinkClicked");
        });
    });
});
