AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-navigation-test", function() {
    "use strict";

    module("JIRA.Projects.Summary.Router", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.mockHistory();

            this.router = JIRA.Projects.Summary.Router.create();

            this.hasPushState = this.sandbox.stub(JIRA.Projects.Util.Browser, "hasPushState");
            this.currentLocation = this.sandbox.stub(JIRA.Projects.Util.Browser, "getCurrentLocation");

            Backbone.history.start({
                pushState: true,
                root: AJS.contextPath() + "/projects/KEY/summary",
                silent: true
            });
        },

        teardown: function() {
            // This is an undocumented Backbone method, called here to avoid having Backbone fiddling
            // with the browser history once the test has finished
            Backbone.history.stop();
            this.sandbox.restore();
        },

        mockHistory: function() {
            this.history = window.history || { pushState: function(){} };
            this.sandbox.stub(this.history, "pushState");
        },

        browserSupportsPushState: function() {
            this.hasPushState.returns(true);
        },

        browserDoesNotSupportPushState: function() {
            this.hasPushState.returns(false);
        },

        currentUrlIs: function(path) {
            this.currentLocation.returns({ pathname: path});
        },

        assertTransformedUrlForPushStateBrowser: function(scenario) {
            this.browserSupportsPushState();
            this.assertTransformedUrl(scenario);
        },

        assertTransformedUrlForNonPushStateBrowser: function(scenario) {
            this.browserDoesNotSupportPushState();
            this.assertTransformedUrl(scenario);
        },

        assertTransformedUrl: function(scenario) {
            this.currentUrlIs(scenario.currentUrl);

            var transformedUrl = this.router.getTransformedUrlForNonPushStateBrowser("KEY");

            equal(transformedUrl, scenario.expectedUrl);
        }
    });

    test("Triggers a 'statistics' event when navigating to the statistics view", function(){
        var statisticsTriggered = this.sandbox.spy();
        this.router.on("statistics", statisticsTriggered);

        this.router.goToStatistics();

        sinon.assert.called(statisticsTriggered);
    });

    test("Triggers a 'activity' event when navigating to the activity view", function(){
        var activityTriggered = this.sandbox.spy();
        this.router.on("activity", activityTriggered);

        this.router.goToActivity();

        sinon.assert.called(activityTriggered);
    });

    test("There is no transformed url if the browser supports push state", function() {
        this.assertTransformedUrlForPushStateBrowser({
            currentUrl: AJS.contextPath() + "/projects/KEY/summary",
            expectedUrl: null
        });
    });

    test("There is a transformed url if the browser does not support push state", function() {
        var scenarios = [
            { currentUrl: AJS.contextPath() + "/projects/KEY/summary/", expectedUrl: AJS.contextPath() + "/projects/KEY/summary#"},
            { currentUrl: AJS.contextPath() + "/projects/KEY/summary/statistics", expectedUrl: AJS.contextPath() + "/projects/KEY/summary#statistics"},
            { currentUrl: AJS.contextPath() + "/projects/KEY/summary#statistics", expectedUrl: null }
        ];

        _.each(scenarios, _.bind(this.assertTransformedUrlForNonPushStateBrowser, this));
    });
});
